/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.validation;

import com.foursoft.harness.navext.runtime.io.utils.XMLIOException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LogValidator {
    private final Validator validator;
    private final List<ErrorLocation> errorLines = new ArrayList<ErrorLocation>();
    private boolean isValid;

    public LogValidator(Validator validator) {
        this.validator = validator;
        this.isValid = true;
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                LogValidator.this.errorLines.add(new ErrorLocation(exception.getLineNumber(), exception.getMessage()));
                LogValidator.this.isValid = false;
            }

            @Override
            public void fatalError(SAXParseException exception) {
                LogValidator.this.errorLines.add(new ErrorLocation(exception.getLineNumber(), exception.getMessage()));
                LogValidator.this.isValid = false;
            }

            @Override
            public void error(SAXParseException exception) {
                LogValidator.this.errorLines.add(new ErrorLocation(exception.getLineNumber(), exception.getMessage()));
                LogValidator.this.isValid = false;
            }
        });
    }

    public Collection<ErrorLocation> getErrorLines() {
        return this.errorLines;
    }

    public boolean validate(Source source) {
        this.isValid = true;
        try {
            this.validator.validate(source);
        }
        catch (IOException | SAXException e) {
            throw new XMLIOException(e.getMessage(), e);
        }
        return this.isValid;
    }

    public static class ErrorLocation {
        public final int line;
        public final String message;

        public ErrorLocation(int line, String message) {
            this.line = line;
            this.message = message;
        }

        public String toString() {
            return "ErrorLocation{line=" + this.line + ", message='" + this.message + "'}";
        }
    }
}

