/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.validation;

import com.foursoft.harness.navext.runtime.io.validation.SchemaFactoryException;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;

public class SchemaFactory {
    private SchemaFactory() {
    }

    public static Schema getSchema(InputStream inputStream) {
        Schema schema;
        block8: {
            InputStream xsdFile = inputStream;
            try {
                javax.xml.validation.SchemaFactory factory = javax.xml.validation.SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                schema = factory.newSchema(new StreamSource(xsdFile));
                if (xsdFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (xsdFile != null) {
                        try {
                            xsdFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SchemaFactoryException("Cannot initialize schema!", e);
                }
            }
            xsdFile.close();
        }
        return schema;
    }

    public static Schema getSchema(String fileName) {
        InputStream inputStream = SchemaFactory.getInputStream(fileName);
        return SchemaFactory.getSchema(inputStream);
    }

    private static InputStream getInputStream(String fileName) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream(fileName);
        return Objects.requireNonNull(is, "Cannot open file: " + fileName);
    }
}

