/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.validation;

import com.foursoft.harness.navext.runtime.io.utils.XMLIOException;
import com.foursoft.harness.navext.runtime.io.validation.LogValidator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

public final class XMLValidation {
    private final Schema schema;

    public XMLValidation(Schema schema) {
        this.schema = schema;
    }

    private static InputStream toInputStream(String input, Charset charset) {
        return new ByteArrayInputStream(input.getBytes(charset));
    }

    public Collection<LogValidator.ErrorLocation> validateXML(String xmlContent, Charset charset) {
        try {
            LogValidator validator = this.createValidator();
            InputStream inputStream = XMLValidation.toInputStream(xmlContent, charset);
            StreamSource inputSource = new StreamSource(inputStream);
            boolean validate = validator.validate(inputSource);
            if (validate) {
                return Collections.emptyList();
            }
            return validator.getErrorLines();
        }
        catch (XMLIOException e) {
            throw new XMLIOException("XML contains fatal errors, cannot read it:", e);
        }
    }

    private LogValidator createValidator() {
        Validator validator = this.schema.newValidator();
        return new LogValidator(validator);
    }
}

