/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.write;

import com.foursoft.harness.navext.runtime.JaxbContextFactory;
import com.foursoft.harness.navext.runtime.io.utils.ValidationEventLogger;
import com.foursoft.harness.navext.runtime.io.utils.XMLIOException;
import com.foursoft.harness.navext.runtime.io.write.NamespacePrefixMapperImpl;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.MarshallerListener;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.XMLMeta;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.XMLMetaAwareXMLStreamWriter;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.comments.CommentAdderListener;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.comments.Comments;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.processinginstructions.ProcessingInstructionAdderListener;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.processinginstructions.ProcessingInstructions;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLWriter<T> {
    private static final String NAMESPACE_PREFIX_MAPPER = "org.glassfish.jaxb.namespacePrefixMapper";
    private final Class<T> baseType;
    private final Marshaller marshaller;

    public XMLWriter(Class<T> baseType) {
        this(baseType, new ValidationEventLogger());
    }

    public XMLWriter(Class<T> baseType, Consumer<ValidationEvent> validationEventConsumer) {
        this.baseType = baseType;
        try {
            String packageName = this.baseType.getPackage().getName();
            JAXBContext jaxbContext = JaxbContextFactory.initializeContext(packageName, NamespacePrefixMapperImpl.class.getClassLoader());
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.marshaller.setProperty(NAMESPACE_PREFIX_MAPPER, (Object)new NamespacePrefixMapperImpl());
            XMLWriter.addEventHandler(this.marshaller, validationEventConsumer);
            this.configureMarshaller(this.marshaller);
        }
        catch (Exception e) {
            throw new XMLIOException("Cannot initialize marshaller.", e);
        }
    }

    public void write(T container, OutputStream outputStream) {
        this.write(container, new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    public void write(T container, XMLMeta meta, OutputStream outputStream) {
        this.write(container, meta, new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    public String writeToString(T container) {
        StringWriter stringWriter = new StringWriter();
        this.write(container, stringWriter);
        return stringWriter.toString();
    }

    public String writeToString(T container, XMLMeta meta) {
        StringWriter stringWriter = new StringWriter();
        this.write(container, meta, stringWriter);
        return stringWriter.toString();
    }

    private static void addEventHandler(Marshaller marshaller, Consumer<ValidationEvent> validationEventConsumer) throws JAXBException {
        ValidationEventHandler eventHandler = marshaller.getEventHandler();
        marshaller.setEventHandler(event -> {
            validationEventConsumer.accept(event);
            return eventHandler.handleEvent(event);
        });
    }

    protected void configureMarshaller(Marshaller marshaller) throws Exception {
    }

    private void write(T container, XMLMeta meta, Writer output) {
        XMLOutputFactory xof = XMLOutputFactory.newFactory();
        try {
            XMLStreamWriter xmlStreamWriter = xof.createXMLStreamWriter(output);
            XMLMetaAwareXMLStreamWriter xsw = new XMLMetaAwareXMLStreamWriter(xmlStreamWriter, this.baseType);
            MarshallerListener marshallerListener = new MarshallerListener();
            this.marshaller.setListener((Marshaller.Listener)marshallerListener);
            meta.getComments().ifPresent(c -> marshallerListener.addListener(new CommentAdderListener(xsw, (Comments)c)));
            meta.getProcessingInstructions().ifPresent(c -> marshallerListener.addListener(new ProcessingInstructionAdderListener(xsw, (ProcessingInstructions)c)));
            this.marshaller.marshal(container, (XMLStreamWriter)((Object)xsw));
            xsw.close();
            marshallerListener.clear();
        }
        catch (JAXBException | XMLStreamException e) {
            throw new XMLIOException("Error serializing XML file.", e);
        }
    }

    private void write(T container, Writer output) {
        try {
            this.marshaller.marshal(container, output);
        }
        catch (JAXBException e) {
            throw new XMLIOException("Error serializing XML file.", e);
        }
    }
}

