/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.write.id;

import com.foursoft.harness.navext.runtime.io.write.id.IdGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleIdGenerator
implements IdGenerator {
    private final Map<String, AtomicInteger> count = new HashMap<String, AtomicInteger>();
    private final int prefixCount;
    private final String delimiter;

    private SimpleIdGenerator(Builder builder) {
        this.prefixCount = builder.prefixCount;
        this.delimiter = builder.delimiter;
    }

    @Override
    public synchronized String getNextId(Object object) {
        AtomicInteger counter = this.count.computeIfAbsent(object.getClass().getSimpleName(), c -> new AtomicInteger(1));
        Object name = object.getClass().getSimpleName().substring(this.prefixCount);
        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
        return (String)name + this.delimiter + counter.getAndIncrement();
    }

    public static final class Builder {
        private int prefixCount = 0;
        private String delimiter = "_";

        public Builder withRemovePrefix(int prefixCount) {
            this.prefixCount = prefixCount;
            return this;
        }

        public Builder withDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public SimpleIdGenerator build() {
            return new SimpleIdGenerator(this);
        }
    }
}

