/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.write.xmlmeta.comments;

import com.foursoft.harness.navext.runtime.io.write.xmlmeta.XMLMetaAwareXMLStreamWriter;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.comments.Comments;
import jakarta.xml.bind.Marshaller;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentAdderListener
extends Marshaller.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommentAdderListener.class);
    private final XMLMetaAwareXMLStreamWriter xsw;
    private final Comments comments;

    public CommentAdderListener(XMLMetaAwareXMLStreamWriter xsw, Comments comments) {
        this.xsw = xsw;
        this.comments = comments;
    }

    public void beforeMarshal(Object source) {
        Optional<String> comment = this.comments.get(source);
        if (comment.isPresent()) {
            try {
                this.xsw.writeComment(comment.get(), source);
            }
            catch (XMLStreamException e) {
                LOGGER.warn("Ignored Exception while writing comments:", (Throwable)e);
            }
        }
    }
}

