/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.io.write.xmlmeta.processinginstructions;

import com.foursoft.harness.navext.runtime.io.write.xmlmeta.XMLMetaAwareXMLStreamWriter;
import com.foursoft.harness.navext.runtime.io.write.xmlmeta.processinginstructions.ProcessingInstructions;
import jakarta.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingInstructionAdderListener
extends Marshaller.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessingInstructionAdderListener.class);
    private final XMLMetaAwareXMLStreamWriter xsw;
    private final ProcessingInstructions processingInstructions;

    public ProcessingInstructionAdderListener(XMLMetaAwareXMLStreamWriter xsw, ProcessingInstructions processingInstructions) {
        this.xsw = xsw;
        this.processingInstructions = processingInstructions;
    }

    public void beforeMarshal(Object source) {
        this.processingInstructions.get(source).forEach(processingInstruction -> {
            String target = processingInstruction.getTarget();
            String data = processingInstruction.getData();
            try {
                this.xsw.writeProcessingInstruction(target, data, source);
            }
            catch (XMLStreamException e) {
                LOGGER.warn("Ignored Exception while writing processingInstruction:", (Throwable)e);
            }
        });
    }
}

