/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.postprocessing;

import com.foursoft.harness.navext.runtime.annotations.XmlBackReference;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessorException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BackReferencePropertyHandler {
    private final Field sourceField;
    private final boolean isCollection;
    private final String destinationFieldName;
    private final Map<Class<?>, Field> destinationFields = new HashMap();

    public BackReferencePropertyHandler(Field field) {
        if (!field.isAnnotationPresent(XmlBackReference.class)) {
            throw new ModelPostProcessorException("For the sourceField " + field.getName() + " in " + field.getDeclaringClass().getName() + " no backreference annotation is present.");
        }
        this.sourceField = field;
        this.sourceField.setAccessible(true);
        this.destinationFieldName = field.getAnnotation(XmlBackReference.class).destinationField();
        this.isCollection = Collection.class.isAssignableFrom(this.sourceField.getType());
    }

    public void handleObject(Object source) {
        try {
            if (this.isCollection) {
                this.handleCollection(source);
            } else {
                this.handleSingleObjectReference(source);
            }
        }
        catch (ModelPostProcessorException e) {
            throw new ModelPostProcessorException("An error occurred during the backreference handling of field: " + this.sourceField.getName() + " for object: " + source, e);
        }
    }

    public void handleCollection(Object sourceObject) {
        try {
            Collection sourceCollection = (Collection)this.sourceField.get(sourceObject);
            if (sourceCollection != null) {
                for (Object destinationObject : sourceCollection) {
                    this.addSourceToDestination(sourceObject, destinationObject);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ModelPostProcessorException(e);
        }
    }

    public void handleSingleObjectReference(Object sourceObject) {
        try {
            Object destinationObject = this.sourceField.get(sourceObject);
            if (destinationObject != null) {
                this.addSourceToDestination(sourceObject, destinationObject);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ModelPostProcessorException(e);
        }
    }

    private Field findDestinationField(Object destinationObject) {
        try {
            return this.destinationFields.computeIfAbsent(destinationObject.getClass(), this::computeDestinationField);
        }
        catch (ModelPostProcessorException e) {
            throw new ModelPostProcessorException("Could not find destination field " + this.destinationFieldName + " for object " + destinationObject, e);
        }
    }

    private Field computeDestinationField(Class<?> destinationClass) {
        try {
            Field result = destinationClass.getDeclaredField(this.destinationFieldName);
            result.setAccessible(true);
            return result;
        }
        catch (SecurityException e) {
            throw new ModelPostProcessorException(e);
        }
        catch (NoSuchFieldException e) {
            if (destinationClass.getSuperclass() != null) {
                return this.computeDestinationField(destinationClass.getSuperclass());
            }
            throw new ModelPostProcessorException("Could not find destination field: " + destinationClass + "." + this.destinationFieldName, e);
        }
    }

    private void addSourceToDestination(Object sourceObject, Object destinationObject) throws IllegalAccessException {
        Set destinationReference = (Set)this.findDestinationField(destinationObject).get(destinationObject);
        destinationReference.add(sourceObject);
    }
}

