/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.postprocessing;

import com.foursoft.harness.navext.runtime.IdLookupProvider;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessor;
import java.util.HashMap;
import java.util.function.Function;

public class IdLookupGeneratorPostProcessor<I>
implements ModelPostProcessor {
    private final Class<I> identifiableElements;
    private final Function<I, String> idMapper;
    private int objectCount = 0;
    private HashMap<String, I> idLookup;

    public IdLookupGeneratorPostProcessor(Class<I> identifiableElements, Function<I, String> idMapper) {
        this.identifiableElements = identifiableElements;
        this.idMapper = idMapper;
    }

    @Override
    public Class<?> getClassToHandle() {
        return this.identifiableElements;
    }

    @Override
    public void afterUnmarshalling(Object target, Object parent) {
        ++this.objectCount;
    }

    @Override
    public void afterUnmarshallingCompleted(Object target) {
        if (this.idLookup == null) {
            this.idLookup = new HashMap(this.objectCount);
        }
        I element = this.identifiableElements.cast(target);
        this.idLookup.put(this.idMapper.apply(element), element);
    }

    @Override
    public void clearState() {
        this.objectCount = 0;
        this.idLookup = null;
    }

    public IdLookupProvider<I> createIdLookkup() {
        return new IdLookupProvider<I>(this.idLookup);
    }
}

