/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.postprocessing;

import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessor;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessorRegistry;
import jakarta.xml.bind.Unmarshaller;
import java.util.LinkedList;
import java.util.List;

public class ModelPostProcessorManager
extends Unmarshaller.Listener {
    private final ModelPostProcessorRegistry modelPostProcessorRegistry;
    private final List<Object> targetObjects = new LinkedList<Object>();

    public ModelPostProcessorManager(ModelPostProcessorRegistry modelPostProcessorRegistry) {
        this.modelPostProcessorRegistry = modelPostProcessorRegistry;
    }

    public void afterUnmarshal(Object target, Object parent) {
        List<ModelPostProcessor> postProcessors = this.modelPostProcessorRegistry.postProcessorsFor(target.getClass());
        for (ModelPostProcessor modelPostProcessor : postProcessors) {
            modelPostProcessor.afterUnmarshalling(target, parent);
        }
        this.targetObjects.add(target);
    }

    public void doPostProcessing() {
        for (Object target : this.targetObjects) {
            List<ModelPostProcessor> postProcessors = this.modelPostProcessorRegistry.postProcessorsFor(target.getClass());
            for (ModelPostProcessor modelPostProcessor : postProcessors) {
                modelPostProcessor.afterUnmarshallingCompleted(target);
            }
        }
    }
}

