/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.postprocessing;

import com.foursoft.harness.navext.runtime.cache.SimpleCache;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class ModelPostProcessorRegistry {
    private final List<ModelPostProcessor> defaultPostProcessor = new LinkedList<ModelPostProcessor>();
    private final String contextPath;
    private SimpleCache<Class<?>, ModelPostProcessor> cachedModelPostProcessorFactory;
    private final SimpleCache<Class<?>, List<ModelPostProcessor>> modelPostProcessors = new SimpleCache<Class, List>(this::createProcessorList);

    public ModelPostProcessorRegistry(String contextPath) {
        this.contextPath = contextPath;
    }

    public ModelPostProcessorRegistry addDefaultPostProcessor(ModelPostProcessor postProcessor) {
        this.defaultPostProcessor.add(postProcessor);
        return this;
    }

    public ModelPostProcessorRegistry withFactory(Function<Class<?>, ModelPostProcessor> modelPostProcessorFactory) {
        this.cachedModelPostProcessorFactory = new SimpleCache<Class, ModelPostProcessor>(modelPostProcessorFactory::apply);
        return this;
    }

    public void clearStateOfPostProcessors() {
        this.cachedModelPostProcessorFactory.getAllLoadedValues().forEach(ModelPostProcessor::clearState);
        this.defaultPostProcessor.forEach(ModelPostProcessor::clearState);
    }

    public <T extends ModelPostProcessor> List<T> findModelPostProcessors(Class<T> postProcessorType) {
        return this.defaultPostProcessor.stream().filter(postProcessorType::isInstance).map(postProcessorType::cast).toList();
    }

    public List<ModelPostProcessor> postProcessorsFor(Class<?> classToHandle) {
        return this.modelPostProcessors.get(classToHandle);
    }

    private List<ModelPostProcessor> createProcessorList(Class<?> classToHandle) {
        LinkedList<ModelPostProcessor> returnValue = new LinkedList<ModelPostProcessor>();
        for (ModelPostProcessor processor : this.defaultPostProcessor) {
            if (!processor.getClassToHandle().isAssignableFrom(classToHandle)) continue;
            returnValue.add(processor);
        }
        if (this.cachedModelPostProcessorFactory != null) {
            returnValue.addAll(this.createIndividualPostProcessorList(classToHandle));
        }
        return returnValue;
    }

    private List<ModelPostProcessor> createIndividualPostProcessorList(Class<?> classToHandle) {
        if (!classToHandle.getName().startsWith(this.contextPath)) {
            return Collections.emptyList();
        }
        LinkedList<ModelPostProcessor> returnValue = new LinkedList<ModelPostProcessor>();
        returnValue.add(this.cachedModelPostProcessorFactory.get(classToHandle));
        if (classToHandle.getSuperclass() != null) {
            returnValue.addAll(this.createIndividualPostProcessorList(classToHandle.getSuperclass()));
        }
        return returnValue;
    }
}

