/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.postprocessing;

import com.foursoft.harness.navext.runtime.annotations.XmlParent;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessorException;
import java.lang.reflect.Field;

public class ParentPropertyHandler {
    private final Field field;
    private final Class<?> typeOfField;

    public ParentPropertyHandler(Field field) {
        if (!field.isAnnotationPresent(XmlParent.class)) {
            throw new ModelPostProcessorException("For the field " + field.getName() + " in " + field.getDeclaringClass().getName() + " no parent annotation is present.");
        }
        this.field = field;
        this.field.setAccessible(true);
        this.typeOfField = field.getType();
    }

    public boolean isHandlingParent(Object parent) {
        return this.typeOfField.isInstance(parent);
    }

    public void handleParentProperty(Object target, Object parent) {
        try {
            this.field.set(target, parent);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ModelPostProcessorException("Can not set parent property value.", e);
        }
    }
}

