/*
 * Decompiled with CFR 0.152.
 */
package com.foursoft.harness.navext.runtime.postprocessing;

import com.foursoft.harness.navext.runtime.annotations.XmlBackReference;
import com.foursoft.harness.navext.runtime.annotations.XmlParent;
import com.foursoft.harness.navext.runtime.postprocessing.BackReferencePropertyHandler;
import com.foursoft.harness.navext.runtime.postprocessing.ModelPostProcessor;
import com.foursoft.harness.navext.runtime.postprocessing.ParentPropertyHandler;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;

public class ReflectiveAssociationPostProcessor
implements ModelPostProcessor {
    private final Class<?> classToHandle;
    private final List<ParentPropertyHandler> parentProperties = new LinkedList<ParentPropertyHandler>();
    private final List<BackReferencePropertyHandler> backReferenceProperties = new LinkedList<BackReferencePropertyHandler>();

    public ReflectiveAssociationPostProcessor(Class<?> classToHandle) {
        this.classToHandle = classToHandle;
        for (Field f : classToHandle.getDeclaredFields()) {
            if (f.isAnnotationPresent(XmlParent.class)) {
                this.parentProperties.add(new ParentPropertyHandler(f));
            }
            if (!f.isAnnotationPresent(XmlBackReference.class)) continue;
            this.backReferenceProperties.add(new BackReferencePropertyHandler(f));
        }
    }

    @Override
    public Class<?> getClassToHandle() {
        return this.classToHandle;
    }

    @Override
    public void afterUnmarshalling(Object target, Object parent) {
        for (ParentPropertyHandler h : this.parentProperties) {
            if (!h.isHandlingParent(parent)) continue;
            h.handleParentProperty(target, parent);
        }
    }

    @Override
    public void afterUnmarshallingCompleted(Object target) {
        for (BackReferencePropertyHandler h : this.backReferenceProperties) {
            h.handleObject(target);
        }
    }

    @Override
    public void clearState() {
    }
}

