/*-
 * ========================LICENSE_START=================================
 * NavExt Runtime
 * %%
 * Copyright (C) 2019 - 2023 4Soft GmbH
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =========================LICENSE_END==================================
 */
package com.foursoft.harness.navext.runtime.io.write;

/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

import org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper;

class NamespacePrefixMapperImpl extends NamespacePrefixMapper {

    /**
     * Returns a preferred prefix for the given namespace URI.
     * <p>
     * This method is intended to be overrided by a derived class.
     *
     * @param namespaceUri  The namespace URI for which the prefix needs to be found.
     *                      Never be null. "" is used to denote the default namespace.
     * @param suggestion    When the content tree has a suggestion for the prefix
     *                      to the given namespaceUri, that suggestion is passed as a
     *                      parameter. Typicall this value comes from the QName.getPrefix
     *                      to show the preference of the content tree. This parameter
     *                      may be null, and this parameter may represent an already
     *                      occupied prefix.
     * @param requirePrefix If this method is expected to return non-empty prefix.
     *                      When this flag is true, it means that the given namespace URI
     *                      cannot be set as the default namespace.
     * @return null if there's no prefered prefix for the namespace URI.
     * In this case, the system will generate a prefix for you.
     * <p>
     * Otherwise the system will try to use the returned prefix,
     * but generally there's no guarantee if the prefix will be
     * actually used or not.
     * <p>
     * return "" to map this namespace URI to the default namespace.
     * Again, there's no guarantee that this preference will be
     * honored.
     * <p>
     * If this method returns "" when requirePrefix=true, the return
     * value will be ignored and the system will generate one.
     */
    @Override
    public String getPreferredPrefix(final String namespaceUri, final String suggestion, final boolean requirePrefix) {
        // I want this namespace to be mapped to "xsi"
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceUri)) {
            return "xsi";
        }

        // I want this namespace to be mapped to "kbl"
        if ("http://www.prostep.org/Car_electric_container/KBL2.3/KBLSchema".equals(namespaceUri)) {
            return "kbl";
        }

        // I want this namespace to be mapped to "vec"
        if ("http://www.prostep.org/ecad-if/2011/vec".equals(namespaceUri)) {
            return "vec";
        }

        // otherwise I don't care. Just use the default suggestion, whatever it may be.
        return suggestion;
    }

}
