//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.3 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v113;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import com.foursoft.harness.navext.runtime.ExtendedUnmarshaller;
import com.foursoft.harness.navext.runtime.annotations.XmlBackReference;
import com.foursoft.harness.navext.runtime.annotations.XmlParent;
import com.foursoft.harness.vec.v113.visitor.Visitable;
import com.foursoft.harness.vec.v113.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>A B-spline curve is a piecewise parametric polynomial or rational curve described in terms of control points and basis functions. The B-spline curve has been selected as the most stable format to represent all types of polynomial or rational parametric curves. With appropriate attribute values it is capable of representing single span or spline curves of explicit polynomial, rational, Bezier or B-spline type.</p>
 *             <p>Within the Harness Engineering Information Model the definition has been restricted to a uniform B_spline_curve, where the knots are evenly spaced. Suitable default values for the knots and knot multiplicities are derived in this case. A B-spline is uniform if and only if all knots are of multiplicity 1 and they differ by a positive constant from the preceding knot. In this case the knot spacing is 1.0, starting at -d, where d is the degree.</p>
 *             <p>Note: If the B-spline curve is uniform and degree=1, the B-spline is equivalent to a polyline.</p>
 * 
 * <p>Java class for BSplineCurve complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="BSplineCurve">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}ExtendableElement">
 *       <sequence>
 *         <element name="Degree" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *         <element name="ControlPoint" type="{http://www.w3.org/2001/XMLSchema}IDREFS" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BSplineCurve", propOrder = {
    "degree",
    "controlPoint"
})
public class VecBSplineCurve
    extends VecExtendableElement
    implements Serializable, Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>The algebraic degree of the basis functions.</p>
     * 
     */
    @XmlElement(name = "Degree", required = true)
    protected BigInteger degree;
    @XmlList
    @XmlElement(name = "ControlPoint", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREFS")
    @XmlBackReference(destinationField = "refBSplineCurve")
    protected List<VecCartesianPoint3D> controlPoint;
    @XmlTransient
    @XmlParent
    private VecGeometrySegment3D parentGeometrySegment3D;

    /**
     * Gets the value of the degree property.
     * <p>
     * <p>The algebraic degree of the basis functions.</p>
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getDegree() {
        return degree;
    }

    /**
     * Sets the value of the degree property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getDegree()
     */
    public void setDegree(BigInteger value) {
        this.degree = value;
    }

    /**
     * Gets the value of the controlPoint property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the controlPoint property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getControlPoint().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    public List<VecCartesianPoint3D> getControlPoint() {
        if (controlPoint == null) {
            controlPoint = new ArrayList<>();
        }
        return this.controlPoint;
    }

    /**
     * Gets a reference to the parent of this object in the XML DOM Tree. If this class can have different parents in DOM, this property is initialized with the parent, if the parent is a {@link VecGeometrySegment3D } otherwise it will be <tt>null</tt>.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public VecGeometrySegment3D getParentGeometrySegment3D() {
        return parentGeometrySegment3D;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecBSplineCurve(this);
    }

}
