//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.3 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v113;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.foursoft.harness.navext.runtime.ExtendedUnmarshaller;
import com.foursoft.harness.navext.runtime.annotations.XmlBackReference;
import com.foursoft.harness.navext.runtime.annotations.XmlParent;
import com.foursoft.harness.vec.common.HasIdentification;
import com.foursoft.harness.vec.common.HasModifiableIdentification;
import com.foursoft.harness.vec.v113.visitor.Visitable;
import com.foursoft.harness.vec.v113.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>A Dimension defines a measurement for the distance between two Locations. An acceptable tolerance can be specified additionally. If the Locations are not located on adjacent topology-elements it is possible to specify a Path for the dimension along which the measurement must be taken.</p>
 *             <p>The value for the Dimension is not specified as Numerical_value (which can define a Tolerance as well). This is because the "valueComponent" of the Numerical_value is mandatory. For Dimensions it shall be optional since there are scenarios where the dimension only specifies a Tolerance for a distance defined by the topology (segment length + placement information).</p>
 * 
 * <p>Java class for Dimension complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="Dimension">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}ConfigurableElement">
 *       <sequence>
 *         <element name="Identification" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="ValueComponent" type="{http://www.w3.org/2001/XMLSchema}double" minOccurs="0"/>
 *         <element name="ValueCalculated" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="DimensionAnchor" type="{http://www.w3.org/2001/XMLSchema}IDREF"/>
 *         <element name="ReferenceAnchor" type="{http://www.w3.org/2001/XMLSchema}IDREF"/>
 *         <element name="UnitComponent" type="{http://www.w3.org/2001/XMLSchema}IDREF"/>
 *         <element name="DefinedLocations" type="{http://www.prostep.org/ecad-if/2011/vec}Location" maxOccurs="2" minOccurs="0"/>
 *         <element name="Path" type="{http://www.prostep.org/ecad-if/2011/vec}Path" minOccurs="0"/>
 *         <element name="Tolerance" type="{http://www.prostep.org/ecad-if/2011/vec}Tolerance" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Dimension", propOrder = {
    "identification",
    "valueComponent",
    "valueCalculated",
    "dimensionAnchor",
    "referenceAnchor",
    "unitComponent",
    "definedLocations",
    "path",
    "tolerance"
})
public class VecDimension
    extends VecConfigurableElement
    implements Serializable, HasIdentification, HasModifiableIdentification, Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>Specifies a unique identification of the Dimension. The identification is guaranteed to be unique within the containing PlacementSpecification.</p>
     * 
     */
    @XmlElement(name = "Identification", required = true)
    protected String identification;
    /**
     * <p>Defines the value of the dimension. This value can be null, if it shall be calculated and only a tolerance shall be defined.</p>
     * 
     */
    @XmlElement(name = "ValueComponent")
    protected Double valueComponent;
    /**
     * <p>Defines if the value of the<i>Dimension</i>was calculated (e.g. the sum of segment lengths in the topology) or if it was defined manually.</p>
     * 
     */
    @XmlElement(name = "ValueCalculated")
    protected Boolean valueCalculated;
    /**
     * <p>References the location that is used as dimension point for the dimensioning (e.g. the entry point of a bundle into a connector housing).</p>
     *                         <p>See KBLFRM-329 and KBLFRM-391.</p>
     * 
     */
    @XmlElement(name = "DimensionAnchor", required = true, type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refDimension")
    protected VecDimensionAnchor dimensionAnchor;
    /**
     * <p>References the location that is used as reference point for the dimensioning (e.g. the location of a fixing as this relates to a fixpoint of the body in white).</p>
     *                         <p>See KBLFRM-329 and KBLFRM-391.</p>
     * 
     */
    @XmlElement(name = "ReferenceAnchor", required = true, type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refDimension")
    protected VecDimensionAnchor referenceAnchor;
    @XmlElement(name = "UnitComponent", required = true, type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refDimension")
    protected VecUnit unitComponent;
    @XmlElement(name = "DefinedLocations")
    protected List<VecLocation> definedLocations;
    @XmlElement(name = "Path")
    protected VecPath path;
    @XmlElement(name = "Tolerance")
    protected VecTolerance tolerance;
    @XmlTransient
    @XmlParent
    private VecPlacementSpecification parentPlacementSpecification;

    /**
     * Gets the value of the identification property.
     * <p>
     * <p>Specifies a unique identification of the Dimension. The identification is guaranteed to be unique within the containing PlacementSpecification.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIdentification() {
        return identification;
    }

    /**
     * Sets the value of the identification property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIdentification()
     */
    public void setIdentification(String value) {
        this.identification = value;
    }

    /**
     * Gets the value of the valueComponent property.
     * <p>
     * <p>Defines the value of the dimension. This value can be null, if it shall be calculated and only a tolerance shall be defined.</p>
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    public Double getValueComponent() {
        return valueComponent;
    }

    /**
     * Sets the value of the valueComponent property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     * @see #getValueComponent()
     */
    public void setValueComponent(Double value) {
        this.valueComponent = value;
    }

    /**
     * Gets the value of the valueCalculated property.
     * <p>
     * <p>Defines if the value of the<i>Dimension</i>was calculated (e.g. the sum of segment lengths in the topology) or if it was defined manually.</p>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isValueCalculated() {
        return valueCalculated;
    }

    /**
     * Sets the value of the valueCalculated property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isValueCalculated()
     */
    public void setValueCalculated(Boolean value) {
        this.valueCalculated = value;
    }

    /**
     * Gets the value of the dimensionAnchor property.
     * <p>
     * <p>References the location that is used as dimension point for the dimensioning (e.g. the entry point of a bundle into a connector housing).</p>
     *                         <p>See KBLFRM-329 and KBLFRM-391.</p>
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecDimensionAnchor getDimensionAnchor() {
        return dimensionAnchor;
    }

    /**
     * Sets the value of the dimensionAnchor property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     * @see #getDimensionAnchor()
     */
    public void setDimensionAnchor(VecDimensionAnchor value) {
        this.dimensionAnchor = value;
    }

    /**
     * Gets the value of the referenceAnchor property.
     * <p>
     * <p>References the location that is used as reference point for the dimensioning (e.g. the location of a fixing as this relates to a fixpoint of the body in white).</p>
     *                         <p>See KBLFRM-329 and KBLFRM-391.</p>
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecDimensionAnchor getReferenceAnchor() {
        return referenceAnchor;
    }

    /**
     * Sets the value of the referenceAnchor property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     * @see #getReferenceAnchor()
     */
    public void setReferenceAnchor(VecDimensionAnchor value) {
        this.referenceAnchor = value;
    }

    /**
     * Gets the value of the unitComponent property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecUnit getUnitComponent() {
        return unitComponent;
    }

    /**
     * Sets the value of the unitComponent property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setUnitComponent(VecUnit value) {
        this.unitComponent = value;
    }

    /**
     * Gets the value of the definedLocations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the definedLocations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDefinedLocations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecLocation }
     * 
     * 
     * @return
     *     The value of the definedLocations property.
     */
    public List<VecLocation> getDefinedLocations() {
        if (definedLocations == null) {
            definedLocations = new ArrayList<>();
        }
        return this.definedLocations;
    }

    /**
     * Gets the value of the path property.
     * 
     * @return
     *     possible object is
     *     {@link VecPath }
     *     
     */
    public VecPath getPath() {
        return path;
    }

    /**
     * Sets the value of the path property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecPath }
     *     
     */
    public void setPath(VecPath value) {
        this.path = value;
    }

    /**
     * Gets the value of the tolerance property.
     * 
     * @return
     *     possible object is
     *     {@link VecTolerance }
     *     
     */
    public VecTolerance getTolerance() {
        return tolerance;
    }

    /**
     * Sets the value of the tolerance property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecTolerance }
     *     
     */
    public void setTolerance(VecTolerance value) {
        this.tolerance = value;
    }

    /**
     * Gets a reference to the parent of this object in the XML DOM Tree. If this class can have different parents in DOM, this property is initialized with the parent, if the parent is a {@link VecPlacementSpecification } otherwise it will be <tt>null</tt>.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public VecPlacementSpecification getParentPlacementSpecification() {
        return parentPlacementSpecification;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecDimension(this);
    }

}
