//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.3 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v113;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.foursoft.harness.vec.v113.visitor.Visitable;
import com.foursoft.harness.vec.v113.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Specification for cavity seals that apply to more than one cavity. A CavitySeal is a water tight non-electrical object to fill a populated Cavity. MultiCavitySeals are formed to fit into one connector / slot and to seal more than one cavity at once.</p>
 *             <p>There are existing two types of MultiCavitySeals:</p>
 *             <ol>
 *                <li>In first type the MultiCavitySeal has an opening for all cavities of the connector. Each opening can be filled either with a wire (without an individual seal) or with a CavityPlug (e.g. a synthetic pin) or a MultiCavityPlug.</li>
 *                <li>In the second type, the MultiCavitySeal has a specific configuration of openings for some cavities of the connector. These MultiCavitySeals are sealing all cavities with an opening and a wire in it and all cavities where no opening in the MultiCavitySeal exists. For each opening that has no wire it an additional CavityPlug is needed. </li>
 *             </ol>
 *             <p>The cavities that are left open by a MultiCavitySeal are defined with a SealedCavitiesAssignment.</p>
 * 
 * <p>Java class for MultiCavitySealSpecification complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="MultiCavitySealSpecification">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}CavitySealSpecification">
 *       <sequence>
 *         <element name="Assignment" type="{http://www.prostep.org/ecad-if/2011/vec}OpenCavitiesAssignment" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MultiCavitySealSpecification", propOrder = {
    "assignments"
})
public class VecMultiCavitySealSpecification
    extends VecCavitySealSpecification
    implements Serializable, Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>References the<i>OpenCavitiesAssignments</i>that are valid for this<i>MultiCavitySeal</i>. One individual<i>OpenCavitiesAssignment</i>is used for each connector housing that matches witch this<i>MultiCavitySeal.</i>
     *                         </p>
     * 
     */
    @XmlElement(name = "Assignment")
    protected List<VecOpenCavitiesAssignment> assignments;

    /**
     * Gets the value of the assignments property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the assignments property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssignments().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecOpenCavitiesAssignment }
     * 
     * <p>
     * <p>References the<i>OpenCavitiesAssignments</i>that are valid for this<i>MultiCavitySeal</i>. One individual<i>OpenCavitiesAssignment</i>is used for each connector housing that matches witch this<i>MultiCavitySeal.</i>
     *                         </p>
     * 
     * @return
     *     The value of the assignments property.
     */
    public List<VecOpenCavitiesAssignment> getAssignments() {
        if (assignments == null) {
            assignments = new ArrayList<>();
        }
        return this.assignments;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecMultiCavitySealSpecification(this);
    }

}
