//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.3 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v113;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.foursoft.harness.navext.runtime.model.Identifiable;
import com.foursoft.harness.navext.runtime.model.ModifiableIdentifiable;
import com.foursoft.harness.vec.common.HasDescription;
import com.foursoft.harness.vec.v113.visitor.Visitable;
import com.foursoft.harness.vec.v113.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Allows the definition of a sealing class. The sealing class of a component is specified as a level of sealing against a specific influence. The influence is specified by the sealingClass and the level is specified by the sealingClassKey. Valid sealing classes and keys are specified by the reference system. Attributes of the type SealingClass normally have the multiplicity [0..*]. This means that such an attribute can have SealingClass entries for different sealingClassReferenceSystems and sealingClasses. It must not have multiple entries for the same sealing class and reference system.</p>
 * 
 * <p>Java class for SealingClass complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SealingClass">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="Class" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="ClassKey" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="ClassReferenceSystem" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="Description" type="{http://www.prostep.org/ecad-if/2011/vec}AbstractLocalizedString" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="id" use="required" type="{http://www.w3.org/2001/XMLSchema}ID" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SealingClass", propOrder = {
    "clazz",
    "classKey",
    "classReferenceSystem",
    "descriptions"
})
public class VecSealingClass implements Serializable, Identifiable, ModifiableIdentifiable, HasDescription<VecAbstractLocalizedString> , Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>Specifies the identifier of a sealing class defined by the sealing class reference system.</p>
     * 
     */
    @XmlElement(name = "Class", required = true)
    protected String clazz;
    /**
     * <p>Specifies a key for the sealing level defined in the specified sealing class (e.g. A, B, C).</p>
     * 
     */
    @XmlElement(name = "ClassKey", required = true)
    protected String classKey;
    /**
     * <p>The identification of the sealing class reference system, which is defining possible values and the semantic of sealing classes and sealing class keys.</p>
     * 
     */
    @XmlElement(name = "ClassReferenceSystem", required = true)
    protected String classReferenceSystem;
    /**
     * <p>On optional human readable description of the sealing class (e.g. the name).</p>
     * 
     */
    @XmlElement(name = "Description")
    protected List<VecAbstractLocalizedString> descriptions;
    @XmlAttribute(name = "id", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String xmlId;

    /**
     * Gets the value of the clazz property.
     * <p>
     * <p>Specifies the identifier of a sealing class defined by the sealing class reference system.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getClazz() {
        return clazz;
    }

    /**
     * Sets the value of the clazz property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getClazz()
     */
    public void setClazz(String value) {
        this.clazz = value;
    }

    /**
     * Gets the value of the classKey property.
     * <p>
     * <p>Specifies a key for the sealing level defined in the specified sealing class (e.g. A, B, C).</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getClassKey() {
        return classKey;
    }

    /**
     * Sets the value of the classKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getClassKey()
     */
    public void setClassKey(String value) {
        this.classKey = value;
    }

    /**
     * Gets the value of the classReferenceSystem property.
     * <p>
     * <p>The identification of the sealing class reference system, which is defining possible values and the semantic of sealing classes and sealing class keys.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getClassReferenceSystem() {
        return classReferenceSystem;
    }

    /**
     * Sets the value of the classReferenceSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getClassReferenceSystem()
     */
    public void setClassReferenceSystem(String value) {
        this.classReferenceSystem = value;
    }

    /**
     * Gets the value of the descriptions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the descriptions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescriptions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecAbstractLocalizedString }
     * 
     * <p>
     * <p>On optional human readable description of the sealing class (e.g. the name).</p>
     * 
     * @return
     *     The value of the descriptions property.
     */
    public List<VecAbstractLocalizedString> getDescriptions() {
        if (descriptions == null) {
            descriptions = new ArrayList<>();
        }
        return this.descriptions;
    }

    /**
     * Gets the value of the xmlId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getXmlId() {
        return xmlId;
    }

    /**
     * Sets the value of the xmlId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setXmlId(String value) {
        this.xmlId = value;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecSealingClass(this);
    }
    @Override public String toString() { return this.getClass().getSimpleName() + "["
            + this.getXmlId() + "]"; }
        
}
