//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.3 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v113;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import com.foursoft.harness.navext.runtime.ExtendedUnmarshaller;
import com.foursoft.harness.vec.v113.visitor.Visitable;
import com.foursoft.harness.vec.v113.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Specification for the definition of terminal receptions. A TerminalReception is the area of a terminal where the contacting with another terminal (e.g. between a connector housing and a control unit) takes place. Normally the terminal reception is placed in a cavity of a connector housing.</p>
 * 
 * <p>Java class for TerminalReceptionSpecification complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TerminalReceptionSpecification">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}Specification">
 *       <sequence>
 *         <element name="CavityDesign" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="PlatingMaterial" type="{http://www.prostep.org/ecad-if/2011/vec}Material" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PrimaryLockingType" type="{http://www.prostep.org/ecad-if/2011/vec}PrimaryLockingType" minOccurs="0"/>
 *         <element name="PullOutForce" type="{http://www.prostep.org/ecad-if/2011/vec}NumericalValue" minOccurs="0"/>
 *         <element name="TerminalType" type="{http://www.prostep.org/ecad-if/2011/vec}TerminalType" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TerminalReceptionSpecification", propOrder = {
    "cavityDesign",
    "platingMaterials",
    "primaryLockingType",
    "pullOutForce",
    "terminalType"
})
public class VecTerminalReceptionSpecification
    extends VecSpecification
    implements Serializable, Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>Specifies the structural shape of the cavity, e.g. round, flat, box that the terminal fits in.</p>
     * 
     */
    @XmlElement(name = "CavityDesign")
    protected String cavityDesign;
    /**
     * <p>Specifies the plating material of the terminal reception.</p>
     * 
     */
    @XmlElement(name = "PlatingMaterial")
    protected List<VecMaterial> platingMaterials;
    /**
     * <p>Specifies if the terminal reception has a primary locking and of what type it is.</p>
     * 
     */
    @XmlElement(name = "PrimaryLockingType")
    protected String primaryLockingType;
    /**
     * <p>The force until the terminal is pulled out of the housing (normally a not intended case). KBLFRM-366</p>
     * 
     */
    @XmlElement(name = "PullOutForce")
    protected VecNumericalValue pullOutForce;
    /**
     * <p>Specifies the terminal type that is associated with the terminal reception.</p>
     * 
     */
    @XmlElement(name = "TerminalType")
    protected VecTerminalType terminalType;
    @XmlTransient
    private Set<VecTerminalReception> refTerminalReception = new HashSet<>();

    /**
     * Gets the value of the cavityDesign property.
     * <p>
     * <p>Specifies the structural shape of the cavity, e.g. round, flat, box that the terminal fits in.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCavityDesign() {
        return cavityDesign;
    }

    /**
     * Sets the value of the cavityDesign property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCavityDesign()
     */
    public void setCavityDesign(String value) {
        this.cavityDesign = value;
    }

    /**
     * Gets the value of the platingMaterials property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the platingMaterials property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPlatingMaterials().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecMaterial }
     * 
     * <p>
     * <p>Specifies the plating material of the terminal reception.</p>
     * 
     * @return
     *     The value of the platingMaterials property.
     */
    public List<VecMaterial> getPlatingMaterials() {
        if (platingMaterials == null) {
            platingMaterials = new ArrayList<>();
        }
        return this.platingMaterials;
    }

    /**
     * Gets the value of the primaryLockingType property.
     * <p>
     * <p>Specifies if the terminal reception has a primary locking and of what type it is.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPrimaryLockingType() {
        return primaryLockingType;
    }

    /**
     * Sets the value of the primaryLockingType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPrimaryLockingType()
     */
    public void setPrimaryLockingType(String value) {
        this.primaryLockingType = value;
    }

    /**
     * Gets the value of the pullOutForce property.
     * <p>
     * <p>The force until the terminal is pulled out of the housing (normally a not intended case). KBLFRM-366</p>
     * 
     * @return
     *     possible object is
     *     {@link VecNumericalValue }
     *     
     */
    public VecNumericalValue getPullOutForce() {
        return pullOutForce;
    }

    /**
     * Sets the value of the pullOutForce property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecNumericalValue }
     *     
     * @see #getPullOutForce()
     */
    public void setPullOutForce(VecNumericalValue value) {
        this.pullOutForce = value;
    }

    /**
     * Gets the value of the terminalType property.
     * <p>
     * <p>Specifies the terminal type that is associated with the terminal reception.</p>
     * 
     * @return
     *     possible object is
     *     {@link VecTerminalType }
     *     
     */
    public VecTerminalType getTerminalType() {
        return terminalType;
    }

    /**
     * Sets the value of the terminalType property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecTerminalType }
     *     
     * @see #getTerminalType()
     */
    public void setTerminalType(VecTerminalType value) {
        this.terminalType = value;
    }

    /**
     * Gets a {@link Set } of all {@link VecTerminalReception } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecTerminalReception> getRefTerminalReception() {
        return refTerminalReception;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecTerminalReceptionSpecification(this);
    }

}
