//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.3 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v113;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import com.foursoft.harness.navext.runtime.ExtendedUnmarshaller;
import com.foursoft.harness.vec.v113.visitor.Visitable;
import com.foursoft.harness.vec.v113.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Specification for the definition of wire receptions. A WireReception is the area of a terminal where the contacting with a wire element (e.g. by crimping) takes place.</p>
 * 
 * <p>Java class for WireReceptionSpecification complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="WireReceptionSpecification">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}Specification">
 *       <sequence>
 *         <element name="CoreCrossSectionArea" type="{http://www.prostep.org/ecad-if/2011/vec}ValueRange" minOccurs="0"/>
 *         <element name="InsulationDisplacementLength" type="{http://www.prostep.org/ecad-if/2011/vec}NumericalValue" minOccurs="0"/>
 *         <element name="MultiContact" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="WireReceptionType" type="{http://www.prostep.org/ecad-if/2011/vec}WireReceptionType" minOccurs="0"/>
 *         <element name="WireElementOutsideDiameter" type="{http://www.prostep.org/ecad-if/2011/vec}ValueRange" minOccurs="0"/>
 *         <element name="PlatingMaterial" type="{http://www.prostep.org/ecad-if/2011/vec}Material" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Sealable" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="ValidConductorMaterials" type="{http://www.prostep.org/ecad-if/2011/vec}ConductorMaterial" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "WireReceptionSpecification", propOrder = {
    "coreCrossSectionArea",
    "insulationDisplacementLength",
    "multiContact",
    "wireReceptionType",
    "wireElementOutsideDiameter",
    "platingMaterials",
    "sealable",
    "validConductorMaterials"
})
public class VecWireReceptionSpecification
    extends VecSpecification
    implements Serializable, Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>Specifies a value range for cross section areas of cores that are compatible with the wire reception.</p>
     *                         <p>For wire receptions where a single core is attached to, this value defines the<i>ValueRange</i>of the<i>crossSectionArea</i>of the core. For wire receptions where more than one core is attached to (e.g. ring terminals, splices), this attributes defines the valid value range for the sum of the cross section areas of all attached cores.</p>
     * 
     */
    @XmlElement(name = "CoreCrossSectionArea")
    protected VecValueRange coreCrossSectionArea;
    /**
     * <p>Specifies the length of the insulation which must be stripped off to fit to this wire reception.</p>
     * 
     */
    @XmlElement(name = "InsulationDisplacementLength")
    protected VecNumericalValue insulationDisplacementLength;
    /**
     * <p>Specifies if it is possible to contact more than core at the wire reception.</p>
     * 
     */
    @XmlElement(name = "MultiContact")
    protected Boolean multiContact;
    /**
     * <p>Specifies the type of the wire reception. The wireReceptionType defines how the wire is joined with the wire reception.</p>
     *                         <p>This attribute is defined in an OpenEnumeration.</p>
     * 
     */
    @XmlElement(name = "WireReceptionType")
    protected String wireReceptionType;
    /**
     * <p>Specifies a value range for valid diameters a WireElement must have to fit to the wire reception.</p>
     * 
     */
    @XmlElement(name = "WireElementOutsideDiameter")
    protected VecValueRange wireElementOutsideDiameter;
    /**
     * <p>Specifies the plating material of the wire reception.</p>
     * 
     */
    @XmlElement(name = "PlatingMaterial")
    protected List<VecMaterial> platingMaterials;
    /**
     * <p>Specifies if the wire reception can be sealed. (see KBLFRM-311)</p>
     * 
     */
    @XmlElement(name = "Sealable")
    protected Boolean sealable;
    /**
     * <p>Specifies the materials of a conductor, that are valid to use with this<i>WireReceptionSpecification</i>. This material shall be matched against the<i>ConductorSpecification.material.</i>
     *                         </p>
     * 
     */
    @XmlElement(name = "ValidConductorMaterials")
    protected List<VecConductorMaterial> validConductorMaterials;
    @XmlTransient
    private Set<VecWireReception> refWireReception = new HashSet<>();

    /**
     * Gets the value of the coreCrossSectionArea property.
     * <p>
     * <p>Specifies a value range for cross section areas of cores that are compatible with the wire reception.</p>
     *                         <p>For wire receptions where a single core is attached to, this value defines the<i>ValueRange</i>of the<i>crossSectionArea</i>of the core. For wire receptions where more than one core is attached to (e.g. ring terminals, splices), this attributes defines the valid value range for the sum of the cross section areas of all attached cores.</p>
     * 
     * @return
     *     possible object is
     *     {@link VecValueRange }
     *     
     */
    public VecValueRange getCoreCrossSectionArea() {
        return coreCrossSectionArea;
    }

    /**
     * Sets the value of the coreCrossSectionArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecValueRange }
     *     
     * @see #getCoreCrossSectionArea()
     */
    public void setCoreCrossSectionArea(VecValueRange value) {
        this.coreCrossSectionArea = value;
    }

    /**
     * Gets the value of the insulationDisplacementLength property.
     * <p>
     * <p>Specifies the length of the insulation which must be stripped off to fit to this wire reception.</p>
     * 
     * @return
     *     possible object is
     *     {@link VecNumericalValue }
     *     
     */
    public VecNumericalValue getInsulationDisplacementLength() {
        return insulationDisplacementLength;
    }

    /**
     * Sets the value of the insulationDisplacementLength property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecNumericalValue }
     *     
     * @see #getInsulationDisplacementLength()
     */
    public void setInsulationDisplacementLength(VecNumericalValue value) {
        this.insulationDisplacementLength = value;
    }

    /**
     * Gets the value of the multiContact property.
     * <p>
     * <p>Specifies if it is possible to contact more than core at the wire reception.</p>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isMultiContact() {
        return multiContact;
    }

    /**
     * Sets the value of the multiContact property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isMultiContact()
     */
    public void setMultiContact(Boolean value) {
        this.multiContact = value;
    }

    /**
     * Gets the value of the wireReceptionType property.
     * <p>
     * <p>Specifies the type of the wire reception. The wireReceptionType defines how the wire is joined with the wire reception.</p>
     *                         <p>This attribute is defined in an OpenEnumeration.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getWireReceptionType() {
        return wireReceptionType;
    }

    /**
     * Sets the value of the wireReceptionType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getWireReceptionType()
     */
    public void setWireReceptionType(String value) {
        this.wireReceptionType = value;
    }

    /**
     * Gets the value of the wireElementOutsideDiameter property.
     * <p>
     * <p>Specifies a value range for valid diameters a WireElement must have to fit to the wire reception.</p>
     * 
     * @return
     *     possible object is
     *     {@link VecValueRange }
     *     
     */
    public VecValueRange getWireElementOutsideDiameter() {
        return wireElementOutsideDiameter;
    }

    /**
     * Sets the value of the wireElementOutsideDiameter property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecValueRange }
     *     
     * @see #getWireElementOutsideDiameter()
     */
    public void setWireElementOutsideDiameter(VecValueRange value) {
        this.wireElementOutsideDiameter = value;
    }

    /**
     * Gets the value of the platingMaterials property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the platingMaterials property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPlatingMaterials().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecMaterial }
     * 
     * <p>
     * <p>Specifies the plating material of the wire reception.</p>
     * 
     * @return
     *     The value of the platingMaterials property.
     */
    public List<VecMaterial> getPlatingMaterials() {
        if (platingMaterials == null) {
            platingMaterials = new ArrayList<>();
        }
        return this.platingMaterials;
    }

    /**
     * Gets the value of the sealable property.
     * <p>
     * <p>Specifies if the wire reception can be sealed. (see KBLFRM-311)</p>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isSealable() {
        return sealable;
    }

    /**
     * Sets the value of the sealable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isSealable()
     */
    public void setSealable(Boolean value) {
        this.sealable = value;
    }

    /**
     * Gets the value of the validConductorMaterials property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the validConductorMaterials property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValidConductorMaterials().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecConductorMaterial }
     * 
     * <p>
     * <p>Specifies the materials of a conductor, that are valid to use with this<i>WireReceptionSpecification</i>. This material shall be matched against the<i>ConductorSpecification.material.</i>
     *                         </p>
     * 
     * @return
     *     The value of the validConductorMaterials property.
     */
    public List<VecConductorMaterial> getValidConductorMaterials() {
        if (validConductorMaterials == null) {
            validConductorMaterials = new ArrayList<>();
        }
        return this.validConductorMaterials;
    }

    /**
     * Gets a {@link Set } of all {@link VecWireReception } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecWireReception> getRefWireReception() {
        return refWireReception;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecWireReceptionSpecification(this);
    }

}
