//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.2 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v12x;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import com.foursoft.harness.navext.runtime.ExtendedUnmarshaller;
import com.foursoft.harness.navext.runtime.annotations.XmlBackReference;
import com.foursoft.harness.navext.runtime.annotations.XmlParent;
import com.foursoft.harness.vec.common.HasDescription;
import com.foursoft.harness.vec.common.HasIdentification;
import com.foursoft.harness.vec.common.HasModifiableIdentification;
import com.foursoft.harness.vec.v12x.visitor.Visitable;
import com.foursoft.harness.vec.v12x.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>A ComponentNode is a node where an electrological component is located. It is a representative for an element in the electric system, e.g. an actuator, a sensor, an ECU. In this way it is quite similar to a NetworkNode and may even reference the corresponding NetworkNode in this case. However, a ComponentNode is more likely to be used as a representative of an inliner or a splice. Moreover, a ComponentNode can define childNodes in order to describe its internal structure.</p>
 * 
 * <p>Java class for ComponentNode complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ComponentNode">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}ConfigurableElement">
 *       <sequence>
 *         <element name="Identification" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="Abbreviation" type="{http://www.prostep.org/ecad-if/2011/vec}LocalizedString" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ComponentNodeType" type="{http://www.prostep.org/ecad-if/2011/vec}ComponentNodeType" minOccurs="0"/>
 *         <element name="Description" type="{http://www.prostep.org/ecad-if/2011/vec}AbstractLocalizedString" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SubType" type="{http://www.prostep.org/ecad-if/2011/vec}ComponentNodeSubType" minOccurs="0"/>
 *         <element name="NetworkNode" type="{http://www.w3.org/2001/XMLSchema}IDREF" minOccurs="0"/>
 *         <element name="RealizedUsageNode" type="{http://www.w3.org/2001/XMLSchema}IDREF" minOccurs="0"/>
 *         <element name="ChildNode" type="{http://www.prostep.org/ecad-if/2011/vec}ComponentNode" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ComponentConnector" type="{http://www.prostep.org/ecad-if/2011/vec}ComponentConnector" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ComponentNode", propOrder = {
    "identification",
    "abbreviations",
    "componentNodeType",
    "descriptions",
    "subType",
    "networkNode",
    "realizedUsageNode",
    "childNodes",
    "componentConnectors"
})
public class VecComponentNode
    extends VecConfigurableElement
    implements Serializable, HasDescription<VecAbstractLocalizedString> , HasIdentification, HasModifiableIdentification, Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>Specifies a unique identification of the ComponentNode. The identification is guaranteed to be unique within the ConnectionSpecification.</p>
     * 
     */
    @XmlElement(name = "Identification", required = true)
    protected String identification;
    /**
     * <p>Room for a short name of the ComponentNode.</p>
     * 
     */
    @XmlElement(name = "Abbreviation")
    protected List<VecLocalizedString> abbreviations;
    /**
     * <p>Specifies the type of the ComponentNode.</p>
     * 
     */
    @XmlElement(name = "ComponentNodeType")
    protected String componentNodeType;
    /**
     * <p>Room for additional, human readable information about the ComponentNode.</p>
     * 
     */
    @XmlElement(name = "Description")
    protected List<VecAbstractLocalizedString> descriptions;
    /**
     * <p>Specifies the sub type of a ComponentNode. The sub type allows a differentiation within a specific type. E.g. an actuator can be differentiated into lamps, speakers, motors. </p>
     * 
     */
    @XmlElement(name = "SubType")
    protected String subType;
    @XmlElement(name = "NetworkNode", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refComponentNode")
    protected VecNetworkNode networkNode;
    /**
     * <p>References the<i>UsageNode</i>that is realized by this<i>ComponentNode</i>.</p>
     * 
     */
    @XmlElement(name = "RealizedUsageNode", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refComponentNode")
    protected VecUsageNode realizedUsageNode;
    @XmlElement(name = "ChildNode")
    protected List<VecComponentNode> childNodes;
    @XmlElement(name = "ComponentConnector")
    protected List<VecComponentConnector> componentConnectors;
    @XmlTransient
    private Set<VecConnectorHousingRole> refConnectorHousingRole = new HashSet<>();
    @XmlTransient
    private Set<VecEEComponentRole> refEEComponentRole = new HashSet<>();
    @XmlTransient
    @XmlParent
    private VecComponentNode parentComponentNode;
    @XmlTransient
    @XmlParent
    private VecConnectionSpecification parentConnectionSpecification;

    /**
     * Gets the value of the identification property.
     * <p>
     * <p>Specifies a unique identification of the ComponentNode. The identification is guaranteed to be unique within the ConnectionSpecification.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIdentification() {
        return identification;
    }

    /**
     * Sets the value of the identification property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIdentification()
     */
    public void setIdentification(String value) {
        this.identification = value;
    }

    /**
     * Gets the value of the abbreviations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the abbreviations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAbbreviations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecLocalizedString }
     * 
     * <p>
     * <p>Room for a short name of the ComponentNode.</p>
     * 
     * @return
     *     The value of the abbreviations property.
     */
    public List<VecLocalizedString> getAbbreviations() {
        if (abbreviations == null) {
            abbreviations = new ArrayList<>();
        }
        return this.abbreviations;
    }

    /**
     * Gets the value of the componentNodeType property.
     * <p>
     * <p>Specifies the type of the ComponentNode.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getComponentNodeType() {
        return componentNodeType;
    }

    /**
     * Sets the value of the componentNodeType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getComponentNodeType()
     */
    public void setComponentNodeType(String value) {
        this.componentNodeType = value;
    }

    /**
     * Gets the value of the descriptions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the descriptions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescriptions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecAbstractLocalizedString }
     * 
     * <p>
     * <p>Room for additional, human readable information about the ComponentNode.</p>
     * 
     * @return
     *     The value of the descriptions property.
     */
    public List<VecAbstractLocalizedString> getDescriptions() {
        if (descriptions == null) {
            descriptions = new ArrayList<>();
        }
        return this.descriptions;
    }

    /**
     * Gets the value of the subType property.
     * <p>
     * <p>Specifies the sub type of a ComponentNode. The sub type allows a differentiation within a specific type. E.g. an actuator can be differentiated into lamps, speakers, motors. </p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubType() {
        return subType;
    }

    /**
     * Sets the value of the subType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSubType()
     */
    public void setSubType(String value) {
        this.subType = value;
    }

    /**
     * Gets the value of the networkNode property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecNetworkNode getNetworkNode() {
        return networkNode;
    }

    /**
     * Sets the value of the networkNode property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setNetworkNode(VecNetworkNode value) {
        this.networkNode = value;
    }

    /**
     * Gets the value of the realizedUsageNode property.
     * <p>
     * <p>References the<i>UsageNode</i>that is realized by this<i>ComponentNode</i>.</p>
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecUsageNode getRealizedUsageNode() {
        return realizedUsageNode;
    }

    /**
     * Sets the value of the realizedUsageNode property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     * @see #getRealizedUsageNode()
     */
    public void setRealizedUsageNode(VecUsageNode value) {
        this.realizedUsageNode = value;
    }

    /**
     * Gets the value of the childNodes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the childNodes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChildNodes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecComponentNode }
     * 
     * 
     * @return
     *     The value of the childNodes property.
     */
    public List<VecComponentNode> getChildNodes() {
        if (childNodes == null) {
            childNodes = new ArrayList<>();
        }
        return this.childNodes;
    }

    /**
     * Gets the value of the componentConnectors property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the componentConnectors property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getComponentConnectors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecComponentConnector }
     * 
     * 
     * @return
     *     The value of the componentConnectors property.
     */
    public List<VecComponentConnector> getComponentConnectors() {
        if (componentConnectors == null) {
            componentConnectors = new ArrayList<>();
        }
        return this.componentConnectors;
    }

    /**
     * Gets a {@link Set } of all {@link VecConnectorHousingRole } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecConnectorHousingRole> getRefConnectorHousingRole() {
        return refConnectorHousingRole;
    }

    /**
     * Gets a {@link Set } of all {@link VecEEComponentRole } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecEEComponentRole> getRefEEComponentRole() {
        return refEEComponentRole;
    }

    /**
     * Gets a reference to the parent of this object in the XML DOM Tree. If this class can have different parents in DOM, this property is initialized with the parent, if the parent is a {@link VecComponentNode } otherwise it will be <tt>null</tt>.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public VecComponentNode getParentComponentNode() {
        return parentComponentNode;
    }

    /**
     * Gets a reference to the parent of this object in the XML DOM Tree. If this class can have different parents in DOM, this property is initialized with the parent, if the parent is a {@link VecConnectionSpecification } otherwise it will be <tt>null</tt>.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public VecConnectionSpecification getParentConnectionSpecification() {
        return parentConnectionSpecification;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecComponentNode(this);
    }

}
