//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.2 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v12x;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import com.foursoft.harness.navext.runtime.ExtendedUnmarshaller;
import com.foursoft.harness.navext.runtime.annotations.XmlBackReference;
import com.foursoft.harness.navext.runtime.annotations.XmlParent;
import com.foursoft.harness.vec.common.HasSpecifications;
import com.foursoft.harness.vec.v12x.visitor.Visitable;
import com.foursoft.harness.vec.v12x.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>The DocumentVersion is one of the two anchors for PDM information in the VEC. All technical information about a PartVersion is contained in one or more documents. The documents are containing the actual content of the VEC since all Specifications are an element of a document.</p>
 * 
 * <p>Java class for DocumentVersion complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="DocumentVersion">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}ItemVersion">
 *       <sequence>
 *         <element name="DocumentNumber" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="DocumentType" type="{http://www.prostep.org/ecad-if/2011/vec}DocumentType" minOccurs="0"/>
 *         <element name="DocumentVersion" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="DigitalRepresentationIndex" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="CreatingSystem" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="DataFormat" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="FileName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="Location" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="NumberOfSheets" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="ReferencedPart" type="{http://www.w3.org/2001/XMLSchema}IDREFS" minOccurs="0"/>
 *         <element name="RelatedDocument" type="{http://www.w3.org/2001/XMLSchema}IDREFS" minOccurs="0"/>
 *         <element name="ItemEquivalence" type="{http://www.prostep.org/ecad-if/2011/vec}ItemEquivalence" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SheetOrChapter" type="{http://www.prostep.org/ecad-if/2011/vec}SheetOrChapter" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Specification" type="{http://www.prostep.org/ecad-if/2011/vec}Specification" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentVersion", propOrder = {
    "documentNumber",
    "documentType",
    "documentVersion",
    "digitalRepresentationIndex",
    "creatingSystem",
    "dataFormat",
    "fileName",
    "location",
    "numberOfSheets",
    "referencedPart",
    "relatedDocument",
    "itemEquivalences",
    "sheetOrChapters",
    "specifications"
})
public class VecDocumentVersion
    extends VecItemVersion
    implements Serializable, HasSpecifications<VecSpecification> , Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>The documentNumber is the major identifier of a DocumentVersion. The format is user defined and respectively company specific.</p>
     * 
     */
    @XmlElement(name = "DocumentNumber", required = true)
    protected String documentNumber;
    /**
     * <p>The type of the document, that is defined in an<i>OpenEnumeration</i>and gives a hint about the content of the document. Values for typical types of documents in the process are predefined (e.g. a part master document for the specification of a<i>PartVersion</i>).</p>
     *                         <p>At later point, further constraint might be attached to<i>documentType</i>defining a minimum content for certain types of documents.</p>
     * 
     */
    @XmlElement(name = "DocumentType")
    protected String documentType;
    /**
     * <p>The documentVersion specifies the version index of a document (see also documentNumber).</p>
     * 
     */
    @XmlElement(name = "DocumentVersion", required = true)
    protected String documentVersion;
    /**
     * <p>An arbitrary change index that indicates if the digital representation (the content in VEC) of this<i>DocumentVersion</i>has been changed / regenerated. This can be for example an index, a timestamp or a checksum. This allows the detection of changes in the content, even when the DocumentNumber &amp; DocumentVersion is the same.</p>
     *                         <p>For a more detailed explanation in the context see "Parts &amp; Documents". KBLFRM-837.</p>
     * 
     */
    @XmlElement(name = "DigitalRepresentationIndex")
    protected String digitalRepresentationIndex;
    /**
     * <p>The creatingSystem specifies the computer application or the machine which is used to create the document.</p>
     * 
     */
    @XmlElement(name = "CreatingSystem")
    protected String creatingSystem;
    /**
     * <p>The dataFormat specifies the convention that was used to structure the information in the document. This is useful if the DocumentVersion is a pointer to an external document, which is not contained in the VEC or if the content of this DocumentVersion was automatically generated by the extraction of the information out of the original document.</p>
     * 
     */
    @XmlElement(name = "DataFormat")
    protected String dataFormat;
    /**
     * <p>The name of the file as it appears in the VEC-Package, including the folder structure (fully qualified name) that contains this<i>DocumentVersion</i>. If this DocumentVersion is a link to an external document (e.g. a ComponentSymbol), then the fileName attribute points to the file containing the original document. The usage of this attribute is only valid, if the original document is distributed along with the VEC-file in a VEC-Package. It must not point to any file location which is not part of the VEC-Package (e.g. a File on a central server file share).</p>
     * 
     */
    @XmlElement(name = "FileName")
    protected String fileName;
    /**
     * <p>The location is a possibility to provide a reference to the source location of the<i>DocumentVersion</i>(e.g. a document management system or an archive system) where the original document can be found<i>.</i>The location shall be provided either as an URN or URL.</p>
     *                         <p> </p>
     * 
     */
    @XmlElement(name = "Location")
    protected String location;
    /**
     * <p>The number of sheets contained in the document.</p>
     * 
     */
    @XmlElement(name = "NumberOfSheets")
    protected String numberOfSheets;
    @XmlList
    @XmlElement(name = "ReferencedPart", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREFS")
    @XmlBackReference(destinationField = "refDocumentVersion")
    protected List<VecPartVersion> referencedPart;
    @XmlList
    @XmlElement(name = "RelatedDocument", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREFS")
    @XmlBackReference(destinationField = "refDocumentVersion")
    protected List<VecDocumentVersion> relatedDocument;
    @XmlElement(name = "ItemEquivalence")
    protected List<VecItemEquivalence> itemEquivalences;
    @XmlElement(name = "SheetOrChapter")
    protected List<VecSheetOrChapter> sheetOrChapters;
    @XmlElement(name = "Specification")
    protected List<VecSpecification> specifications;
    @XmlTransient
    private Set<VecExtendableElement> refExtendableElement = new HashSet<>();
    @XmlTransient
    private Set<VecDocumentVersion> refDocumentVersion = new HashSet<>();
    @XmlTransient
    private Set<VecDocumentBasedInstruction> refDocumentBasedInstruction = new HashSet<>();
    @XmlTransient
    private Set<VecDocumentRelatedAssignmentGroup> refDocumentRelatedAssignmentGroup = new HashSet<>();
    @XmlTransient
    private Set<VecExternalMappingSpecification> refExternalMappingSpecification = new HashSet<>();
    @XmlTransient
    private Set<VecRequirementsConformanceStatement> refRequirementsConformanceStatement = new HashSet<>();
    @XmlTransient
    @XmlParent
    private VecContent parentVecContent;

    /**
     * Gets the value of the documentNumber property.
     * <p>
     * <p>The documentNumber is the major identifier of a DocumentVersion. The format is user defined and respectively company specific.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /**
     * Sets the value of the documentNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDocumentNumber()
     */
    public void setDocumentNumber(String value) {
        this.documentNumber = value;
    }

    /**
     * Gets the value of the documentType property.
     * <p>
     * <p>The type of the document, that is defined in an<i>OpenEnumeration</i>and gives a hint about the content of the document. Values for typical types of documents in the process are predefined (e.g. a part master document for the specification of a<i>PartVersion</i>).</p>
     *                         <p>At later point, further constraint might be attached to<i>documentType</i>defining a minimum content for certain types of documents.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDocumentType() {
        return documentType;
    }

    /**
     * Sets the value of the documentType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDocumentType()
     */
    public void setDocumentType(String value) {
        this.documentType = value;
    }

    /**
     * Gets the value of the documentVersion property.
     * <p>
     * <p>The documentVersion specifies the version index of a document (see also documentNumber).</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDocumentVersion() {
        return documentVersion;
    }

    /**
     * Sets the value of the documentVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDocumentVersion()
     */
    public void setDocumentVersion(String value) {
        this.documentVersion = value;
    }

    /**
     * Gets the value of the digitalRepresentationIndex property.
     * <p>
     * <p>An arbitrary change index that indicates if the digital representation (the content in VEC) of this<i>DocumentVersion</i>has been changed / regenerated. This can be for example an index, a timestamp or a checksum. This allows the detection of changes in the content, even when the DocumentNumber &amp; DocumentVersion is the same.</p>
     *                         <p>For a more detailed explanation in the context see "Parts &amp; Documents". KBLFRM-837.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDigitalRepresentationIndex() {
        return digitalRepresentationIndex;
    }

    /**
     * Sets the value of the digitalRepresentationIndex property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDigitalRepresentationIndex()
     */
    public void setDigitalRepresentationIndex(String value) {
        this.digitalRepresentationIndex = value;
    }

    /**
     * Gets the value of the creatingSystem property.
     * <p>
     * <p>The creatingSystem specifies the computer application or the machine which is used to create the document.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCreatingSystem() {
        return creatingSystem;
    }

    /**
     * Sets the value of the creatingSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreatingSystem()
     */
    public void setCreatingSystem(String value) {
        this.creatingSystem = value;
    }

    /**
     * Gets the value of the dataFormat property.
     * <p>
     * <p>The dataFormat specifies the convention that was used to structure the information in the document. This is useful if the DocumentVersion is a pointer to an external document, which is not contained in the VEC or if the content of this DocumentVersion was automatically generated by the extraction of the information out of the original document.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDataFormat() {
        return dataFormat;
    }

    /**
     * Sets the value of the dataFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDataFormat()
     */
    public void setDataFormat(String value) {
        this.dataFormat = value;
    }

    /**
     * Gets the value of the fileName property.
     * <p>
     * <p>The name of the file as it appears in the VEC-Package, including the folder structure (fully qualified name) that contains this<i>DocumentVersion</i>. If this DocumentVersion is a link to an external document (e.g. a ComponentSymbol), then the fileName attribute points to the file containing the original document. The usage of this attribute is only valid, if the original document is distributed along with the VEC-file in a VEC-Package. It must not point to any file location which is not part of the VEC-Package (e.g. a File on a central server file share).</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * Sets the value of the fileName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFileName()
     */
    public void setFileName(String value) {
        this.fileName = value;
    }

    /**
     * Gets the value of the location property.
     * <p>
     * <p>The location is a possibility to provide a reference to the source location of the<i>DocumentVersion</i>(e.g. a document management system or an archive system) where the original document can be found<i>.</i>The location shall be provided either as an URN or URL.</p>
     *                         <p> </p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLocation() {
        return location;
    }

    /**
     * Sets the value of the location property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLocation()
     */
    public void setLocation(String value) {
        this.location = value;
    }

    /**
     * Gets the value of the numberOfSheets property.
     * <p>
     * <p>The number of sheets contained in the document.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNumberOfSheets() {
        return numberOfSheets;
    }

    /**
     * Sets the value of the numberOfSheets property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getNumberOfSheets()
     */
    public void setNumberOfSheets(String value) {
        this.numberOfSheets = value;
    }

    /**
     * Gets the value of the itemEquivalences property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the itemEquivalences property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemEquivalences().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecItemEquivalence }
     * 
     * 
     * @return
     *     The value of the itemEquivalences property.
     */
    public List<VecItemEquivalence> getItemEquivalences() {
        if (itemEquivalences == null) {
            itemEquivalences = new ArrayList<>();
        }
        return this.itemEquivalences;
    }

    /**
     * Gets the value of the sheetOrChapters property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the sheetOrChapters property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSheetOrChapters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecSheetOrChapter }
     * 
     * 
     * @return
     *     The value of the sheetOrChapters property.
     */
    public List<VecSheetOrChapter> getSheetOrChapters() {
        if (sheetOrChapters == null) {
            sheetOrChapters = new ArrayList<>();
        }
        return this.sheetOrChapters;
    }

    /**
     * Gets the value of the specifications property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifications property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifications().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecSpecification }
     * 
     * 
     * @return
     *     The value of the specifications property.
     */
    public List<VecSpecification> getSpecifications() {
        if (specifications == null) {
            specifications = new ArrayList<>();
        }
        return this.specifications;
    }

    /**
     * Gets a {@link Set } of all {@link VecExtendableElement } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecExtendableElement> getRefExtendableElement() {
        return refExtendableElement;
    }

    /**
     * Gets the value of the referencedPart property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the referencedPart property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReferencedPart().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    public List<VecPartVersion> getReferencedPart() {
        if (referencedPart == null) {
            referencedPart = new ArrayList<>();
        }
        return this.referencedPart;
    }

    /**
     * Gets the value of the relatedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the relatedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRelatedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    public List<VecDocumentVersion> getRelatedDocument() {
        if (relatedDocument == null) {
            relatedDocument = new ArrayList<>();
        }
        return this.relatedDocument;
    }

    /**
     * Gets a {@link Set } of all {@link VecDocumentVersion } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecDocumentVersion> getRefDocumentVersion() {
        return refDocumentVersion;
    }

    /**
     * Gets a {@link Set } of all {@link VecDocumentBasedInstruction } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecDocumentBasedInstruction> getRefDocumentBasedInstruction() {
        return refDocumentBasedInstruction;
    }

    /**
     * Gets a {@link Set } of all {@link VecDocumentRelatedAssignmentGroup } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecDocumentRelatedAssignmentGroup> getRefDocumentRelatedAssignmentGroup() {
        return refDocumentRelatedAssignmentGroup;
    }

    /**
     * Gets a {@link Set } of all {@link VecExternalMappingSpecification } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecExternalMappingSpecification> getRefExternalMappingSpecification() {
        return refExternalMappingSpecification;
    }

    /**
     * Gets a {@link Set } of all {@link VecRequirementsConformanceStatement } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecRequirementsConformanceStatement> getRefRequirementsConformanceStatement() {
        return refRequirementsConformanceStatement;
    }

    /**
     * Gets a reference to the parent of this object in the XML DOM Tree. If this class can have different parents in DOM, this property is initialized with the parent, if the parent is a {@link VecContent } otherwise it will be <tt>null</tt>.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public VecContent getParentVecContent() {
        return parentVecContent;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecDocumentVersion(this);
    }

}
