//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.2 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v12x;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import com.foursoft.harness.vec.v12x.visitor.Visitable;
import com.foursoft.harness.vec.v12x.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>The NURBSCurve represents the parameter set of a NURBS (Non-Uniform rational B-Spline) in the VEC. For a complete definition of NURBS see for example (<a href="https://en.wikipedia.org/wiki/Non-uniform_rational_B-spline">https://en.wikipedia.org/wiki/Non-uniform_rational_B-spline</a>).</p>
 *             <p> </p>
 *             <p>Basically, a NURBS curve is defined by:</p>
 *             <ul>
 *                <li>a<b>degree</b>
 *                </li>
 *                <li>a list of<b>control points</b>: with at least<i>degree + 1</i>points.</li>
 *                <li>a<b>weight</b>for each control point.</li>
 *                <li>a<b>knots</b>vector: a list of numbers, with (<i>degree + #controlpoints +1)</i>elements. Every number must be equal or greater than its predecessor, and the same value must not be repeated more than<i>degree</i>times. It seems that modern NURBS algorithms just require (<i>degree + #controlpoints -1)</i>control points.</li>
 *             </ul>
 *             <p>Commonly used default assignments for the parameters are:</p>
 *             <ul>
 *                <li>
 *                   <b>weight = 1</b>for all control points: In this case the curve is called "non-rational".</li>
 *                <li>
 *                   <b>knot</b>vector: equidistant and increasing values in the knot vector (e.g. 1,2,3,4,5,6,7) means the curve is "uniform" which exists in two variants.<ul>
 *                      <li>
 *                         <b>clamped</b>(or pinned): If the knot vector starts and ends with<i>degree</i>times the same value (e.g. degree = 3, knots = [0,0,0,1,2,3,4,5,5,5], then it is<i>clamped.</i>This has the effect, that the first and last control point coincide with the start and end point of the curve.</li>
 *                      <li>
 *                         <b>unclamped</b>(or unpinned): If there are no repeated values in the knot vector (e.g. 1,2,3,4,5,6,7) it is unclamped.</li>
 *                   </ul>
 *                </li>
 *             </ul>
 *             <p>The VEC <i>NURBSCurve</i>corresponds to removed<i>BSplineCurve</i>(VEC Version &lt;= 1.1.3 and KBL). However, the<i>BSplineCurve</i>did not define weight and knot vector, so default assignments where assumed. Existing implementations are using "uniform non-rational b splines", unfortunately some implementations use "uniform clamped" and some "unclamped".</p>
 *             <p>Since a NURBS cannot be rendered correctly without the knowledge of all parameters and to avoid further misconceptions the VEC allows the definition of all parameters of a NURBS. Furthermore, it requires the specification of all parameters, even if some known default assignment (e.g. non-rational) is used. </p>
 * 
 * <p>Java class for NURBSCurve complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="NURBSCurve">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}Curve3D">
 *       <sequence>
 *         <element name="Degree" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *         <element name="Knots" type="{http://www.w3.org/2001/XMLSchema}double" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ControlPoint" type="{http://www.prostep.org/ecad-if/2011/vec}NURBSControlPoint" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "NURBSCurve", propOrder = {
    "degree",
    "knots",
    "controlPoints"
})
public class VecNURBSCurve
    extends VecCurve3D
    implements Serializable, Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <i>NURBSCurve).</i>
     * 
     */
    @XmlElement(name = "Degree", required = true)
    protected BigInteger degree;
    /**
     * <p>Defines the knot-vector of the NURBS(for details see the class description of<i>NURBSCurve).</i>
     *                         </p>
     * 
     */
    @XmlElement(name = "Knots", type = Double.class)
    protected List<Double> knots;
    /**
     * <p>Defines the control points of the NURBS curve (for details see the class description of<i>NURBSCurve)</i>
     *                         </p>
     * 
     */
    @XmlElement(name = "ControlPoint")
    protected List<VecNURBSControlPoint> controlPoints;

    /**
     * Gets the value of the degree property.
     * <p>
     * <i>NURBSCurve).</i>
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getDegree() {
        return degree;
    }

    /**
     * Sets the value of the degree property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getDegree()
     */
    public void setDegree(BigInteger value) {
        this.degree = value;
    }

    /**
     * Gets the value of the knots property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the knots property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getKnots().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Double }
     * 
     * <p>
     * <p>Defines the knot-vector of the NURBS(for details see the class description of<i>NURBSCurve).</i>
     *                         </p>
     * 
     * @return
     *     The value of the knots property.
     */
    public List<Double> getKnots() {
        if (knots == null) {
            knots = new ArrayList<>();
        }
        return this.knots;
    }

    /**
     * Gets the value of the controlPoints property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the controlPoints property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getControlPoints().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecNURBSControlPoint }
     * 
     * <p>
     * <p>Defines the control points of the NURBS curve (for details see the class description of<i>NURBSCurve)</i>
     *                         </p>
     * 
     * @return
     *     The value of the controlPoints property.
     */
    public List<VecNURBSControlPoint> getControlPoints() {
        if (controlPoints == null) {
            controlPoints = new ArrayList<>();
        }
        return this.controlPoints;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecNURBSCurve(this);
    }

}
