//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.2 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package com.foursoft.harness.vec.v12x;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import com.foursoft.harness.navext.runtime.ExtendedUnmarshaller;
import com.foursoft.harness.navext.runtime.annotations.XmlBackReference;
import com.foursoft.harness.vec.v12x.visitor.Visitable;
import com.foursoft.harness.vec.v12x.visitor.Visitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>A WireElementSpecification is the basic element to describe a wire in the VEC. A WireElementSpecification can be atomic or composed recursively out of other WireElementSpecifications. A WireElementSpecification can reference an InsulationSpecification, if it has an insulation, a CoreSpecification, if it has a core or a WireGroupSpecification if it is a grouping of other WireElementSpecifications in the Wire (e.g. a multi-core wire with twisted pairs).</p>
 * 
 * <p>Java class for WireElementSpecification complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="WireElementSpecification">
 *   <complexContent>
 *     <extension base="{http://www.prostep.org/ecad-if/2011/vec}Specification">
 *       <sequence>
 *         <element name="Type" type="{http://www.prostep.org/ecad-if/2011/vec}WireType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="MinBendRadiusDynamic" type="{http://www.prostep.org/ecad-if/2011/vec}NumericalValue" minOccurs="0"/>
 *         <element name="MinBendRadiusStatic" type="{http://www.prostep.org/ecad-if/2011/vec}NumericalValue" minOccurs="0"/>
 *         <element name="OutsideDiameter" type="{http://www.prostep.org/ecad-if/2011/vec}NumericalValue" minOccurs="0"/>
 *         <element name="SuitedForDynamicUse" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         <element name="Impedance" type="{http://www.prostep.org/ecad-if/2011/vec}NumericalValue" minOccurs="0"/>
 *         <element name="Size" type="{http://www.prostep.org/ecad-if/2011/vec}Size" minOccurs="0"/>
 *         <element name="ValidWireReceptionTypes" type="{http://www.prostep.org/ecad-if/2011/vec}WireReceptionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="GridSpacing" type="{http://www.prostep.org/ecad-if/2011/vec}NumericalValue" minOccurs="0"/>
 *         <element name="Shape" type="{http://www.prostep.org/ecad-if/2011/vec}WireElementShape" minOccurs="0"/>
 *         <element name="ConductorSpecification" type="{http://www.w3.org/2001/XMLSchema}IDREF" minOccurs="0"/>
 *         <element name="FillerSpecification" type="{http://www.w3.org/2001/XMLSchema}IDREF" minOccurs="0"/>
 *         <element name="InsulationSpecification" type="{http://www.w3.org/2001/XMLSchema}IDREF" minOccurs="0"/>
 *         <element name="SubWireElementSpecification" type="{http://www.w3.org/2001/XMLSchema}IDREFS" minOccurs="0"/>
 *         <element name="WireGroupSpecification" type="{http://www.w3.org/2001/XMLSchema}IDREF" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "WireElementSpecification", propOrder = {
    "types",
    "minBendRadiusDynamic",
    "minBendRadiusStatic",
    "outsideDiameter",
    "suitedForDynamicUse",
    "impedance",
    "size",
    "validWireReceptionTypes",
    "gridSpacing",
    "shape",
    "conductorSpecification",
    "fillerSpecification",
    "insulationSpecification",
    "subWireElementSpecification",
    "wireGroupSpecification"
})
public class VecWireElementSpecification
    extends VecSpecification
    implements Serializable, Visitable
{

    private static final long serialVersionUID = 1L;
    /**
     * <p>Defines the type of the wire. A wire must not have more than one type. This attribute allows more than one value for the reason, that the same type can be expressed in multiple reference systems.</p>
     * 
     */
    @XmlElement(name = "Type")
    protected List<VecWireType> types;
    /**
     * <p>Specifies the minimum bend radius for wire element, if it is used in a dynamic environment, where it is bended repeatedly (e.g. in grommet of the back door). (see KLBFRM-311)</p>
     * 
     */
    @XmlElement(name = "MinBendRadiusDynamic")
    protected VecNumericalValue minBendRadiusDynamic;
    /**
     * <p>Specifies the minimum bend radius for wire element, if it is used in a static environment, where it is bended once during installation. After that it remains unchanged in its bended position during usage. (see KLBFRM-311)</p>
     * 
     */
    @XmlElement(name = "MinBendRadiusStatic")
    protected VecNumericalValue minBendRadiusStatic;
    /**
     * <p>Specifies the outside diameter of the WireElement.</p>
     * 
     */
    @XmlElement(name = "OutsideDiameter")
    protected VecNumericalValue outsideDiameter;
    /**
     * <p>Specifies if it is allowed to use the WireElement in a dynamic environment. (see KBLFRM-311)</p>
     * 
     */
    @XmlElement(name = "SuitedForDynamicUse")
    protected Boolean suitedForDynamicUse;
    /**
     * <p>Defines the impedance of this wireElement. Typically used for WireElements that have subWireElements e.g. twisted pair or coax wires.</p>
     * 
     */
    @XmlElement(name = "Impedance")
    protected VecNumericalValue impedance;
    /**
     * <p>Defines the size of a WireElement if it has not the shape of circle. If it has the shape of a circle the size is normally defined by its outside diameter.</p>
     * 
     */
    @XmlElement(name = "Size")
    protected VecSize size;
    /**
     * <p>Defines the<i>WireReceptionTypes</i>that are allowed for joining with the specified<i>WireElement.</i>
     *                         </p>
     * 
     */
    @XmlElement(name = "ValidWireReceptionTypes")
    protected List<String> validWireReceptionTypes;
    /**
     * <p>Defines the grid spacing. The grid spacing is the distance between the centres of two adjacent sub wire elements.</p>
     *                         <p>This attribute is only valid for<i>WireElementSpecifications</i>that have<i>SubWireElementSpecifications.</i>
     *                         </p>
     * 
     */
    @XmlElement(name = "GridSpacing")
    protected VecNumericalValue gridSpacing;
    /**
     * <p>Defines the shape of a<i>WireElement.</i>Circular wire elements are defined by their outsideDiameter, all others are defined by their size.</p>
     * 
     */
    @XmlElement(name = "Shape")
    protected String shape;
    /**
     * <p>If the<i>WireElement</i>has a core then the specification of the core is referenced here.</p>
     * 
     */
    @XmlElement(name = "ConductorSpecification", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refWireElementSpecification")
    protected VecConductorSpecification conductorSpecification;
    /**
     * <p>If the<i>WireElement</i>is a filler then the specification of the filler is referenced here.</p>
     * 
     */
    @XmlElement(name = "FillerSpecification", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refWireElementSpecification")
    protected VecFillerSpecification fillerSpecification;
    /**
     * <p>If the<i>WireElement</i>has an insulation then the specification of the insulation is referenced here.</p>
     * 
     */
    @XmlElement(name = "InsulationSpecification", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refWireElementSpecification")
    protected VecInsulationSpecification insulationSpecification;
    /**
     * <p>Specifies the contained subWireElements if the WireElement has sub elements. If a<i>WireElementSpecification</i>contains the same<i>WireElementSpecification</i>multiple times, then it shall be referenced as often as it occurs in the reality. Otherwise the<i>WireElementSpecification</i>wouldn't specify a wire element unambiguously, because the representation in the model would be the same, regardless of the number of sub elements. Therefore, this association must not be realized with a "set" semantic.</p>
     *                         <p> </p>
     * 
     */
    @XmlList
    @XmlElement(name = "SubWireElementSpecification", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREFS")
    @XmlBackReference(destinationField = "refWireElementSpecification")
    protected List<VecWireElementSpecification> subWireElementSpecification;
    /**
     * <p>If the<i>WireElementSpecification</i>is representing a wire group, then the specification of the wire group is referenced here. That means as well, that the<i>WireElementSpecification</i>shall have<i>subWireElementSpecifications</i>.</p>
     * 
     */
    @XmlElement(name = "WireGroupSpecification", type = Object.class)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @XmlBackReference(destinationField = "refWireElementSpecification")
    protected VecWireGroupSpecification wireGroupSpecification;
    @XmlTransient
    private Set<VecWireElement> refWireElement = new HashSet<>();
    @XmlTransient
    private Set<VecWireElementSpecification> refWireElementSpecification = new HashSet<>();
    @XmlTransient
    private Set<VecWireSpecification> refWireSpecification = new HashSet<>();

    /**
     * Gets the value of the types property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the types property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTypes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VecWireType }
     * 
     * <p>
     * <p>Defines the type of the wire. A wire must not have more than one type. This attribute allows more than one value for the reason, that the same type can be expressed in multiple reference systems.</p>
     * 
     * @return
     *     The value of the types property.
     */
    public List<VecWireType> getTypes() {
        if (types == null) {
            types = new ArrayList<>();
        }
        return this.types;
    }

    /**
     * Gets the value of the minBendRadiusDynamic property.
     * <p>
     * <p>Specifies the minimum bend radius for wire element, if it is used in a dynamic environment, where it is bended repeatedly (e.g. in grommet of the back door). (see KLBFRM-311)</p>
     * 
     * @return
     *     possible object is
     *     {@link VecNumericalValue }
     *     
     */
    public VecNumericalValue getMinBendRadiusDynamic() {
        return minBendRadiusDynamic;
    }

    /**
     * Sets the value of the minBendRadiusDynamic property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecNumericalValue }
     *     
     * @see #getMinBendRadiusDynamic()
     */
    public void setMinBendRadiusDynamic(VecNumericalValue value) {
        this.minBendRadiusDynamic = value;
    }

    /**
     * Gets the value of the minBendRadiusStatic property.
     * <p>
     * <p>Specifies the minimum bend radius for wire element, if it is used in a static environment, where it is bended once during installation. After that it remains unchanged in its bended position during usage. (see KLBFRM-311)</p>
     * 
     * @return
     *     possible object is
     *     {@link VecNumericalValue }
     *     
     */
    public VecNumericalValue getMinBendRadiusStatic() {
        return minBendRadiusStatic;
    }

    /**
     * Sets the value of the minBendRadiusStatic property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecNumericalValue }
     *     
     * @see #getMinBendRadiusStatic()
     */
    public void setMinBendRadiusStatic(VecNumericalValue value) {
        this.minBendRadiusStatic = value;
    }

    /**
     * Gets the value of the outsideDiameter property.
     * <p>
     * <p>Specifies the outside diameter of the WireElement.</p>
     * 
     * @return
     *     possible object is
     *     {@link VecNumericalValue }
     *     
     */
    public VecNumericalValue getOutsideDiameter() {
        return outsideDiameter;
    }

    /**
     * Sets the value of the outsideDiameter property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecNumericalValue }
     *     
     * @see #getOutsideDiameter()
     */
    public void setOutsideDiameter(VecNumericalValue value) {
        this.outsideDiameter = value;
    }

    /**
     * Gets the value of the suitedForDynamicUse property.
     * <p>
     * <p>Specifies if it is allowed to use the WireElement in a dynamic environment. (see KBLFRM-311)</p>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isSuitedForDynamicUse() {
        return suitedForDynamicUse;
    }

    /**
     * Sets the value of the suitedForDynamicUse property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isSuitedForDynamicUse()
     */
    public void setSuitedForDynamicUse(Boolean value) {
        this.suitedForDynamicUse = value;
    }

    /**
     * Gets the value of the impedance property.
     * <p>
     * <p>Defines the impedance of this wireElement. Typically used for WireElements that have subWireElements e.g. twisted pair or coax wires.</p>
     * 
     * @return
     *     possible object is
     *     {@link VecNumericalValue }
     *     
     */
    public VecNumericalValue getImpedance() {
        return impedance;
    }

    /**
     * Sets the value of the impedance property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecNumericalValue }
     *     
     * @see #getImpedance()
     */
    public void setImpedance(VecNumericalValue value) {
        this.impedance = value;
    }

    /**
     * Gets the value of the size property.
     * <p>
     * <p>Defines the size of a WireElement if it has not the shape of circle. If it has the shape of a circle the size is normally defined by its outside diameter.</p>
     * 
     * @return
     *     possible object is
     *     {@link VecSize }
     *     
     */
    public VecSize getSize() {
        return size;
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecSize }
     *     
     * @see #getSize()
     */
    public void setSize(VecSize value) {
        this.size = value;
    }

    /**
     * Gets the value of the validWireReceptionTypes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the validWireReceptionTypes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValidWireReceptionTypes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * <p>
     * <p>Defines the<i>WireReceptionTypes</i>that are allowed for joining with the specified<i>WireElement.</i>
     *                         </p>
     * 
     * @return
     *     The value of the validWireReceptionTypes property.
     */
    public List<String> getValidWireReceptionTypes() {
        if (validWireReceptionTypes == null) {
            validWireReceptionTypes = new ArrayList<>();
        }
        return this.validWireReceptionTypes;
    }

    /**
     * Gets the value of the gridSpacing property.
     * <p>
     * <p>Defines the grid spacing. The grid spacing is the distance between the centres of two adjacent sub wire elements.</p>
     *                         <p>This attribute is only valid for<i>WireElementSpecifications</i>that have<i>SubWireElementSpecifications.</i>
     *                         </p>
     * 
     * @return
     *     possible object is
     *     {@link VecNumericalValue }
     *     
     */
    public VecNumericalValue getGridSpacing() {
        return gridSpacing;
    }

    /**
     * Sets the value of the gridSpacing property.
     * 
     * @param value
     *     allowed object is
     *     {@link VecNumericalValue }
     *     
     * @see #getGridSpacing()
     */
    public void setGridSpacing(VecNumericalValue value) {
        this.gridSpacing = value;
    }

    /**
     * Gets the value of the shape property.
     * <p>
     * <p>Defines the shape of a<i>WireElement.</i>Circular wire elements are defined by their outsideDiameter, all others are defined by their size.</p>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getShape() {
        return shape;
    }

    /**
     * Sets the value of the shape property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getShape()
     */
    public void setShape(String value) {
        this.shape = value;
    }

    /**
     * Gets the value of the conductorSpecification property.
     * <p>
     * <p>If the<i>WireElement</i>has a core then the specification of the core is referenced here.</p>
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecConductorSpecification getConductorSpecification() {
        return conductorSpecification;
    }

    /**
     * Sets the value of the conductorSpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     * @see #getConductorSpecification()
     */
    public void setConductorSpecification(VecConductorSpecification value) {
        this.conductorSpecification = value;
    }

    /**
     * Gets the value of the fillerSpecification property.
     * <p>
     * <p>If the<i>WireElement</i>is a filler then the specification of the filler is referenced here.</p>
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecFillerSpecification getFillerSpecification() {
        return fillerSpecification;
    }

    /**
     * Sets the value of the fillerSpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     * @see #getFillerSpecification()
     */
    public void setFillerSpecification(VecFillerSpecification value) {
        this.fillerSpecification = value;
    }

    /**
     * Gets the value of the insulationSpecification property.
     * <p>
     * <p>If the<i>WireElement</i>has an insulation then the specification of the insulation is referenced here.</p>
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecInsulationSpecification getInsulationSpecification() {
        return insulationSpecification;
    }

    /**
     * Sets the value of the insulationSpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     * @see #getInsulationSpecification()
     */
    public void setInsulationSpecification(VecInsulationSpecification value) {
        this.insulationSpecification = value;
    }

    /**
     * Gets the value of the wireGroupSpecification property.
     * <p>
     * <p>If the<i>WireElementSpecification</i>is representing a wire group, then the specification of the wire group is referenced here. That means as well, that the<i>WireElementSpecification</i>shall have<i>subWireElementSpecifications</i>.</p>
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public VecWireGroupSpecification getWireGroupSpecification() {
        return wireGroupSpecification;
    }

    /**
     * Sets the value of the wireGroupSpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     * @see #getWireGroupSpecification()
     */
    public void setWireGroupSpecification(VecWireGroupSpecification value) {
        this.wireGroupSpecification = value;
    }

    /**
     * Gets a {@link Set } of all {@link VecWireElement } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecWireElement> getRefWireElement() {
        return refWireElement;
    }

    /**
     * Gets the value of the subWireElementSpecification property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the subWireElementSpecification property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSubWireElementSpecification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * <p>
     * <p>Specifies the contained subWireElements if the WireElement has sub elements. If a<i>WireElementSpecification</i>contains the same<i>WireElementSpecification</i>multiple times, then it shall be referenced as often as it occurs in the reality. Otherwise the<i>WireElementSpecification</i>wouldn't specify a wire element unambiguously, because the representation in the model would be the same, regardless of the number of sub elements. Therefore, this association must not be realized with a "set" semantic.</p>
     *                         <p> </p>
     * 
     */
    public List<VecWireElementSpecification> getSubWireElementSpecification() {
        if (subWireElementSpecification == null) {
            subWireElementSpecification = new ArrayList<>();
        }
        return this.subWireElementSpecification;
    }

    /**
     * Gets a {@link Set } of all {@link VecWireElementSpecification } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecWireElementSpecification> getRefWireElementSpecification() {
        return refWireElementSpecification;
    }

    /**
     * Gets a {@link Set } of all {@link VecWireSpecification } that have a outgoing reference to this object.<br/>
     * <b>Warning!:</b> This is a readonly property! It has to be initialized during the unmarshalling process by the {@link ExtendedUnmarshaller }.<br/>This property is consistent to the state of object model at the time of unmarshalling. It does <b>not</b> reflect any changes done in the object model after the unmarshalling.<br/>
     * This property has no effect when the object is marshalled to xml.
     * 
     */
    public Set<VecWireSpecification> getRefWireSpecification() {
        return refWireSpecification;
    }

    public<R, E extends Throwable >R accept(Visitor<R, E> aVisitor)
        throws E
    {
        return aVisitor.visitVecWireElementSpecification(this);
    }

}
