/*
 * Decompiled with CFR 0.152.
 */
package com.foursquare.android.nativeoauth;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.text.TextUtils;
import com.foursquare.android.nativeoauth.FoursquareCancelException;
import com.foursquare.android.nativeoauth.FoursquareDenyException;
import com.foursquare.android.nativeoauth.FoursquareInternalErrorException;
import com.foursquare.android.nativeoauth.FoursquareInvalidRequestException;
import com.foursquare.android.nativeoauth.FoursquareOAuthException;
import com.foursquare.android.nativeoauth.FoursquareUnsupportedVersionException;
import com.foursquare.android.nativeoauth.TokenExchangeActivity;
import com.foursquare.android.nativeoauth.model.AccessTokenResponse;
import com.foursquare.android.nativeoauth.model.AuthCodeResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public final class FoursquareOAuth {
    private static final String PACKAGE = "com.joelapenna.foursquared";
    private static final String INTENT_RESULT_CODE = "com.joelapenna.foursquared.fragments.OauthWebviewFragment.INTENT_RESULT_CODE";
    private static final String INTENT_RESULT_ERROR = "com.joelapenna.foursquared.fragments.OauthWebviewFragment.INTENT_RESULT_ERROR";
    private static final String INTENT_RESULT_DENIED = "com.joelapenna.foursquared.fragments.OauthWebviewFragment.INTENT_RESULT_DENIED";
    private static final String INTENT_RESULT_ERROR_MESSAGE = "com.joelapenna.foursquared.fragments.OauthWebviewFragment.INTENT_RESULT_ERROR_MESSAGE";
    private static final String URI_SCHEME = "foursquareauth";
    private static final String URI_AUTHORITY = "authorize";
    private static final String PARAM_CLIENT_ID = "client_id";
    private static final String PARAM_SIGNATURE = "androidKeyHash";
    private static final String PARAM_VERSION = "v";
    private static final String URI_MARKET_PAGE = "market://details?id=com.joelapenna.foursquared";
    private static final String MARKET_REFERRER = "utm_source=foursquare-android-oauth&utm_term=%s";
    private static final String ERROR_CODE_UNSUPPORTED_VERSION = "unsupported_version";
    private static final String ERROR_CODE_INVALID_REQUEST = "invalid_request";
    private static final String ERROR_CODE_INTERNAL_ERROR = "internal_error";
    private static final int LIB_VERSION = 20130509;

    public static Intent getConnectIntent(Context context, String clientId) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(URI_SCHEME);
        builder.authority(URI_AUTHORITY);
        builder.appendQueryParameter(PARAM_CLIENT_ID, clientId);
        builder.appendQueryParameter(PARAM_VERSION, String.valueOf(20130509));
        builder.appendQueryParameter(PARAM_SIGNATURE, FoursquareOAuth.getSignatureFingerprint(context));
        Intent intent = new Intent("android.intent.action.VIEW", builder.build());
        if (FoursquareOAuth.isIntentAvailable(context, intent)) {
            return intent;
        }
        return FoursquareOAuth.getPlayStoreIntent(clientId);
    }

    public static AuthCodeResponse getAuthCodeFromResult(int resultCode, Intent data) {
        AuthCodeResponse response = new AuthCodeResponse();
        switch (resultCode) {
            case -1: {
                boolean denied = data.getBooleanExtra(INTENT_RESULT_DENIED, false);
                String authCode = data.getStringExtra(INTENT_RESULT_CODE);
                String errorCode = data.getStringExtra(INTENT_RESULT_ERROR);
                String errorMessage = data.getStringExtra(INTENT_RESULT_ERROR_MESSAGE);
                if (denied) {
                    response.setException(new FoursquareDenyException());
                } else if (TextUtils.isEmpty((CharSequence)errorCode)) {
                    response.setCode(authCode);
                } else if (ERROR_CODE_INVALID_REQUEST.equals(errorCode)) {
                    response.setException(new FoursquareInvalidRequestException(errorMessage));
                } else if (ERROR_CODE_UNSUPPORTED_VERSION.equals(errorCode)) {
                    response.setException(new FoursquareUnsupportedVersionException(errorMessage));
                } else if (ERROR_CODE_INTERNAL_ERROR.equals(errorCode)) {
                    response.setException(new FoursquareInternalErrorException(errorMessage));
                } else {
                    response.setException(new FoursquareOAuthException(errorCode));
                }
                return response;
            }
        }
        response.setException(new FoursquareCancelException());
        return response;
    }

    public static Intent getTokenExchangeIntent(Context context, String clientId, String clientSecret, String authCode) {
        Intent intent = new Intent();
        intent.setClass(context, TokenExchangeActivity.class);
        intent.putExtra(TokenExchangeActivity.INTENT_EXTRA_CLIENT_ID, clientId);
        intent.putExtra(TokenExchangeActivity.INTENT_EXTRA_CLIENT_SECRET, clientSecret);
        intent.putExtra(TokenExchangeActivity.INTENT_EXTRA_AUTH_CODE, authCode);
        return intent;
    }

    public static AccessTokenResponse getTokenFromResult(int resultCode, Intent data) {
        if (resultCode == -1) {
            return (AccessTokenResponse)data.getSerializableExtra(TokenExchangeActivity.INTENT_RESULT_RESPONSE);
        }
        return null;
    }

    public static boolean isPlayStoreIntent(Intent intent) {
        Uri marketUri = Uri.parse((String)URI_MARKET_PAGE);
        Uri uri = intent.getData();
        return intent != null && "android.intent.action.VIEW".equals(intent.getAction()) && marketUri.getScheme().equals(uri.getScheme()) && marketUri.getHost().equals(uri.getHost()) && marketUri.getQueryParameter("id").equals(uri.getQueryParameter("id"));
    }

    private static Intent getPlayStoreIntent(String clientId) {
        String referrer = String.format(MARKET_REFERRER, clientId);
        return new Intent("android.intent.action.VIEW", Uri.parse((String)URI_MARKET_PAGE).buildUpon().appendQueryParameter("referrer", referrer).build());
    }

    private static boolean isIntentAvailable(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentActivities(intent, 65536);
        return resolveInfo.size() > 0;
    }

    private static String getSignatureFingerprint(Context context) {
        Signature[] signatures;
        String callingPackage = context.getApplicationContext().getPackageName();
        PackageManager pm = context.getPackageManager();
        int flags = 64;
        PackageInfo callingPackageInfo = null;
        try {
            callingPackageInfo = pm.getPackageInfo(callingPackage, flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        if (callingPackageInfo != null && (signatures = callingPackageInfo.signatures) != null && signatures.length > 0) {
            byte[] cert = signatures[0].toByteArray();
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                byte[] fingerprint = md.digest(cert);
                StringBuffer hexString = new StringBuffer();
                for (int i = 0; i < fingerprint.length; ++i) {
                    String appendString = Integer.toHexString(0xFF & fingerprint[i]);
                    if (hexString.length() > 0) {
                        hexString.append(":");
                    }
                    if (appendString.length() == 1) {
                        hexString.append("0");
                    }
                    hexString.append(appendString);
                }
                String signature = hexString.toString().toUpperCase();
                return signature;
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

