/*
 * Decompiled with CFR 0.152.
 */
package com.foursquare.android.nativeoauth;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.foursquare.android.nativeoauth.FoursquareInternalErrorException;
import com.foursquare.android.nativeoauth.FoursquareOAuthException;
import com.foursquare.android.nativeoauth.R;
import com.foursquare.android.nativeoauth.model.AccessTokenResponse;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public final class TokenExchangeActivity
extends Activity {
    private static final String TAG = TokenExchangeActivity.class.getName();
    public static final String INTENT_EXTRA_CLIENT_ID = TAG + ".INTENT_EXTRA_CLIENT_ID";
    public static final String INTENT_EXTRA_CLIENT_SECRET = TAG + ".INTENT_EXTRA_CLIENT_SECRET";
    public static final String INTENT_EXTRA_AUTH_CODE = TAG + ".INTENT_EXTRA_AUTH_CODE";
    public static final String INTENT_RESULT_RESPONSE = TAG + ".INTENT_RESULT_RESPONSE";
    private static final String INTENT_EXTRA_TOKEN_EXCHANGE_TASK = TAG + ".INTENT_EXTRA_TOKEN_EXCHANGE_TASK";
    private static final String HTTP_BASE = "https://foursquare.com/oauth2/access_token?";
    private static final String ACCESS_TOKEN_URL = "https://foursquare.com/oauth2/access_token?client_id=%s&client_secret=%s&grant_type=authorization_code&code=%s";
    private TokenExchangeTask mTask;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setTheme(this.getThemeRes());
        this.setContentView(R.layout.loading);
        String clientId = this.getIntent().getStringExtra(INTENT_EXTRA_CLIENT_ID);
        String clientSecret = this.getIntent().getStringExtra(INTENT_EXTRA_CLIENT_SECRET);
        String authCode = this.getIntent().getStringExtra(INTENT_EXTRA_AUTH_CODE);
        if (savedInstanceState == null) {
            this.mTask = new TokenExchangeTask(this);
            this.mTask.execute(new String[]{clientId, clientSecret, authCode});
        } else {
            this.mTask = (TokenExchangeTask)savedInstanceState.getSerializable(INTENT_EXTRA_TOKEN_EXCHANGE_TASK);
            this.mTask.setActivity(this);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable(INTENT_EXTRA_TOKEN_EXCHANGE_TASK, (Serializable)this.mTask);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    public void onBackPressed() {
    }

    private void onTokenComplete(AccessTokenResponse response) {
        Intent data = new Intent();
        data.putExtra(INTENT_RESULT_RESPONSE, (Serializable)response);
        this.setResult(-1, data);
        this.finish();
    }

    @SuppressLint(value={"InlinedApi"})
    private int getThemeRes() {
        if (Build.VERSION.SDK_INT < 11) {
            return 16973835;
        }
        if (Build.VERSION.SDK_INT < 14) {
            return 16973942;
        }
        return 16974133;
    }

    static class TokenExchangeTask
    extends AsyncTask<String, Void, AccessTokenResponse>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private TokenExchangeActivity mActivity;

        public TokenExchangeTask(TokenExchangeActivity activity) {
            this.mActivity = activity;
        }

        public void setActivity(TokenExchangeActivity activity) {
            this.mActivity = activity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected AccessTokenResponse doInBackground(String ... params) {
            String accessTokenUrl = String.format(TokenExchangeActivity.ACCESS_TOKEN_URL, params[0], params[1], params[2]);
            AccessTokenResponse result = null;
            HttpURLConnection connection = null;
            try {
                URL url = new URL(accessTokenUrl);
                connection = (HttpURLConnection)url.openConnection();
                InputStream in = connection.getInputStream();
                String json = this.readStream(in);
                result = this.parseAccessToken(json);
            }
            catch (MalformedURLException e) {
                result = this.createErrorResponse(e);
            }
            catch (IOException e) {
                result = this.createErrorResponse(e);
            }
            catch (JSONException e) {
                result = this.createErrorResponse((Exception)((Object)e));
            }
            catch (Exception e) {
                result = this.createErrorResponse(e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return result;
        }

        protected void onPostExecute(AccessTokenResponse result) {
            this.mActivity.onTokenComplete(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readStream(InputStream in) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int count;
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
                String string = new String(out.toByteArray(), "UTF-8");
                return string;
            }
            finally {
                this.closeQuietly(out);
            }
        }

        private void closeQuietly(Closeable closeable) {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private AccessTokenResponse parseAccessToken(String json) throws JSONException {
            AccessTokenResponse response = new AccessTokenResponse();
            JSONObject obj = new JSONObject(json);
            String errorCode = obj.optString("error");
            if (TextUtils.isEmpty((CharSequence)errorCode)) {
                response.setAccessToken(obj.optString("access_token"));
            } else {
                response.setException(new FoursquareOAuthException(errorCode));
            }
            return response;
        }

        private AccessTokenResponse createErrorResponse(Exception e) {
            AccessTokenResponse response = new AccessTokenResponse();
            response.setException(new FoursquareInternalErrorException(e));
            return response;
        }
    }
}

