/*
 * Decompiled with CFR 0.152.
 */
package com.foursquare.geo.quadtree;

import com.foursquare.geo.quadtree.ShapefileGeo;
import com.foursquare.geo.quadtree.ShapefileGeo$;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import org.geotools.data.FileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scalaj.collection.Imports$;
import scalaj.collection.j2s.Coercible$;

public final class ShapefileGeo$ {
    public static final ShapefileGeo$ MODULE$;
    private final GeometryFactory geometryFactory;
    private final String indexAttributePrefix;

    static {
        new ShapefileGeo$();
    }

    public GeometryFactory geometryFactory() {
        return this.geometryFactory;
    }

    public String indexAttributePrefix() {
        return this.indexAttributePrefix;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ShapefileGeo.ShapeTrieNode load(URL url, String keyAttribute, Option<Set<String>> validValues, String defaultValue, boolean alwaysCheckGeometry) {
        String string;
        HashMap<String, Serializable> dataStoreParams = new HashMap<String, Serializable>();
        dataStoreParams.put(ShapefileDataStoreFactory.URLP.key, url);
        dataStoreParams.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, Boolean.TRUE);
        dataStoreParams.put(ShapefileDataStoreFactory.CACHE_MEMORY_MAPS.key, Boolean.FALSE);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        FileDataStore dataStore = (FileDataStore)dataStoreFactory.createDataStore(dataStoreParams);
        SimpleFeatureSource featureSource = dataStore.getFeatureSource();
        if (((SimpleFeatureType)featureSource.getSchema()).getDescriptor(keyAttribute) == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Schema has no attribute named \"").append((Object)keyAttribute).append((Object)"\"").toString());
        }
        Option option = Imports$.MODULE$.RichJIterable((Iterable)featureSource.getSchema().getDescriptors()).asScala(Coercible$.MODULE$.CoercibleSelf()).find((Function1)new anonfun.6());
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Schema has no attribute starting with \"").append((Object)this.indexAttributePrefix()).append((Object)"\"").toString());
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        PropertyDescriptor descriptor = (PropertyDescriptor)some.x();
        String indexAttribute = string = descriptor.getName().toString();
        int[] sourceLevelSizes = (int[])Predef$.MODULE$.refArrayOps((Object[])indexAttribute.substring(this.indexAttributePrefix().length()).split("_")).map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        ReferencedEnvelope bounds = featureSource.getInfo().getBounds();
        ShapefileGeo.ShapeTrieNode world = new ShapefileGeo.ShapeTrieNode(0, new ShapefileGeo.GeoBounds(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight()), alwaysCheckGeometry);
        SimpleFeatureIterator iterator = featureSource.getFeatures().features();
        try {
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry sourceGeometry = (Geometry)feature.getDefaultGeometry();
                String keyValueCopy = feature.getAttribute(keyAttribute).toString();
                String keyValue = BoxesRunTime.unboxToBoolean((Object)validValues.map((Function1)new scala.Serializable(keyValueCopy){
                    public static final long serialVersionUID = 0L;
                    private final String keyValueCopy$1;

                    public final boolean apply(Set<String> vv) {
                        return vv.apply((Object)this.keyValueCopy$1);
                    }
                    {
                        this.keyValueCopy$1 = keyValueCopy$1;
                    }
                }).getOrElse((Function0)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                })) ? keyValueCopy : defaultValue;
                List index = this.parseIndex$1(feature.getAttribute(indexAttribute).toString());
                world.addFeature((List<Tuple2<Object, Object>>)index, keyValue, sourceGeometry, sourceLevelSizes);
            }
        }
        catch (Throwable throwable) {
            void var19_19;
            var19_19.close();
            throw throwable;
        }
        iterator.close();
        return world;
    }

    private final List parseIndex$1(String path) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])path.split(";")).foldRight((Object)Nil$.MODULE$, (Function2)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<Object, Object>> apply(String elem, List<Tuple2<Object, Object>> list) {
                int[] elemArr = (int[])Predef$.MODULE$.refArrayOps((Object[])elem.split(",", 2)).map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String e) {
                        return new StringOps(Predef$.MODULE$.augmentString(e)).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(elemArr[0], elemArr[1]);
                return list.$colon$colon((Object)sp2);
            }
        });
    }

    private ShapefileGeo$() {
        MODULE$ = this;
        this.geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        this.indexAttributePrefix = "GI";
    }
}

