/*
 * Decompiled with CFR 0.152.
 */
package com.foursquare.geo.quadtree;

import com.foursquare.geo.quadtree.ShapefileGeo;
import com.foursquare.geo.quadtree.ShapefileGeo$;
import com.foursquare.geo.quadtree.ShapefileSimplifier$$anonfun$com$foursquare$geo$quadtree$ShapefileSimplifier$;
import com.foursquare.geo.quadtree.ShapefileSimplifier$$anonfun$com$foursquare$geo$quadtree$ShapefileSimplifier$$gridifyList$1$2$;
import com.foursquare.geo.quadtree.ShapefileSimplifier$Coords$;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.util.ArrayList;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scalaj.collection.Imports$;
import scalaj.collection.s2j.Coercible$;

public final class ShapefileSimplifier$ {
    public static final ShapefileSimplifier$ MODULE$;
    private final int[] defaultLevels;

    static {
        new ShapefileSimplifier$();
    }

    public int[] defaultLevels() {
        return this.defaultLevels;
    }

    public void simplify(ShapefileGeo.ShapeTrieNode node, int[] levels) {
        this.com$foursquare$geo$quadtree$ShapefileSimplifier$$gridifyList$1(node, levels);
    }

    public void saveSimplifiedFeatures(AbstractDataStore featureStore, ShapefileGeo.ShapeTrieNode world) {
        DefaultTransaction transaction = new DefaultTransaction("addShapes");
        SimpleFeatureType schema = featureStore.getSchema((Name)featureStore.getNames().get(0));
        FeatureWriter writer = featureStore.getFeatureWriterAppend(schema.getTypeName(), (Transaction)transaction);
        this.com$foursquare$geo$quadtree$ShapefileSimplifier$$enumerateFeatures$1(world, "", writer);
        writer.close();
        transaction.commit();
        transaction.close();
    }

    public AbstractDataStore createSimplifiedFeatureStore(File simplified, SimpleFeatureSource originalSource, String keyAttribute, String simplifiedKeyAttribute, int[] levels) {
        ShapefileDataStoreFactory storeFactory = new ShapefileDataStoreFactory();
        scala.collection.immutable.Map create = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"url"), (Object)simplified.toURI().toURL())}));
        DataStore saveStore = storeFactory.createNewDataStore(Imports$.MODULE$.RichSMap((Map)create).asJava(Coercible$.MODULE$.CoercibleSelf(), Coercible$.MODULE$.CoercibleSelf()));
        SimpleFeatureType oldSchema = (SimpleFeatureType)originalSource.getSchema();
        ArrayList<Object> descriptorList = new ArrayList<Object>();
        boolean index = false;
        descriptorList.add(oldSchema.getGeometryDescriptor());
        AttributeDescriptor originalKeyAttribute = oldSchema.getDescriptor(keyAttribute);
        AttributeTypeBuilder keyTB = new AttributeTypeBuilder();
        keyTB.setName(simplifiedKeyAttribute);
        keyTB.setBinding(String.class);
        keyTB.setNillable(originalKeyAttribute.isNillable());
        descriptorList.add(keyTB.buildDescriptor(simplifiedKeyAttribute));
        String indexAttribute = new StringBuilder().append((Object)ShapefileGeo$.MODULE$.indexAttributePrefix()).append((Object)Predef$.MODULE$.intArrayOps(levels).mkString("_")).toString();
        if (indexAttribute.length() > 10) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Stringification of levels is too long for DBF format. Index ").append((Object)indexAttribute).append((Object)" must be less than or equal to length 10").toString());
        }
        AttributeTypeBuilder indexTB = new AttributeTypeBuilder();
        indexTB.setName(indexAttribute);
        indexTB.setBinding(String.class);
        indexTB.setNillable(false);
        descriptorList.add(indexTB.buildDescriptor(indexAttribute));
        SimpleFeatureTypeImpl newSchema = new SimpleFeatureTypeImpl((Name)new NameImpl(simplified.getName()), descriptorList, oldSchema.getGeometryDescriptor(), oldSchema.isAbstract(), oldSchema.getRestrictions(), oldSchema.getSuper(), null);
        saveStore.createSchema((FeatureType)newSchema);
        return (AbstractDataStore)saveStore;
    }

    public SimpleFeatureSource getFeatureSource(File file) {
        FileDataStore dataStore = FileDataStoreFinder.getDataStore((File)file);
        return dataStore.getFeatureSource();
    }

    /*
     * WARNING - void declaration
     */
    public ShapefileGeo.ShapeTrieNode loadOriginal(SimpleFeatureSource featureSource, String keyAttribute, Option<scala.collection.immutable.Map<String, String>> keyMap) {
        if (((SimpleFeatureType)featureSource.getSchema()).getDescriptor(keyAttribute) == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Schema has no attribute named \"").append((Object)keyAttribute).append((Object)"\"").toString());
        }
        ReferencedEnvelope bounds = featureSource.getInfo().getBounds();
        ShapefileGeo.ShapeTrieNode world = new ShapefileGeo.ShapeTrieNode(0, new ShapefileGeo.GeoBounds(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight()), true);
        SimpleFeatureIterator iterator = featureSource.getFeatures().features();
        try {
            while (iterator.hasNext()) {
                Option<scala.collection.immutable.Map<String, String>> option;
                block9: {
                    String string;
                    Geometry sourceGeometry;
                    block8: {
                        String origKeyValue;
                        block7: {
                            SimpleFeature feature = (SimpleFeature)iterator.next();
                            sourceGeometry = (Geometry)feature.getDefaultGeometry();
                            origKeyValue = feature.getAttribute(keyAttribute).toString();
                            option = keyMap;
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            scala.collection.immutable.Map map = (scala.collection.immutable.Map)some.x();
                            string = (String)map.getOrElse((Object)origKeyValue, (Function0)new Serializable(origKeyValue){
                                public static final long serialVersionUID = 0L;
                                private final String origKeyValue$1;

                                public final Nothing$ apply() {
                                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Can't find ").append((Object)this.origKeyValue$1).append((Object)" in map").toString());
                                }
                                {
                                    this.origKeyValue$1 = origKeyValue$1;
                                }
                            });
                            break block8;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<scala.collection.immutable.Map<String, String>> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                        string = origKeyValue;
                    }
                    String keyValue = string;
                    world.subList_$eq((List<ShapefileGeo.ShapeLeafNode>)world.subList().$colon$colon((Object)new ShapefileGeo.ShapeLeafNode(keyValue, sourceGeometry)));
                    continue;
                }
                throw new MatchError(option);
            }
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.close();
            throw throwable;
        }
        iterator.close();
        return world;
    }

    public void doSimplification(File original, File simplified, String keyAttribute, int[] levels, Option<scala.collection.immutable.Map<String, String>> keyMap, Option<String> newKeyAttribute) {
        String simplifiedKeyAttribute = (String)newKeyAttribute.getOrElse((Function0)new Serializable(keyAttribute){
            public static final long serialVersionUID = 0L;
            private final String keyAttribute$1;

            public final String apply() {
                return this.keyAttribute$1;
            }
            {
                this.keyAttribute$1 = keyAttribute$1;
            }
        });
        SimpleFeatureSource originalSource = this.getFeatureSource(original);
        ShapefileGeo.ShapeTrieNode world = this.loadOriginal(originalSource, keyAttribute, keyMap);
        this.simplify(world, levels);
        AbstractDataStore featureStore = this.createSimplifiedFeatureStore(simplified, originalSource, keyAttribute, simplifiedKeyAttribute, levels);
        this.saveSimplifiedFeatures(featureStore, world);
    }

    public void main(String[] args) {
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"Error: you didn't specify the correct number of parmeters!");
            Predef$.MODULE$.println((Object)"run-class com.foursquare.batch.ShapefileSimplifier \n\t<original-shapefile.shp>\n\t<simplified-shapefile.shp>\n\t<key-name>\n\t[underscore-separated-levels]");
            Predef$.MODULE$.println((Object)"Example:");
            Predef$.MODULE$.println((Object)"run-class com.foursquare.batch.ShapefileSimplifier tz_world.shp new/4sq_tz.shp TZID 40_2_2_2");
            System.exit(1);
        }
        File original = new File(args[0]);
        File simplified = new File(args[1]);
        String keyAttribute = args[2];
        if (!original.exists()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)args[0]).append((Object)" not found!").toString());
            System.exit(1);
        }
        if (simplified.exists()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)args[1]).append((Object)" already exists! Too scared to overwrite.").toString());
            System.exit(1);
        }
        int[] levels = args.length > 3 ? (int[])Predef$.MODULE$.refArrayOps((Object[])args[3].split("_")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())) : this.defaultLevels();
        this.doSimplification(original, simplified, keyAttribute, levels, (Option<scala.collection.immutable.Map<String, String>>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public final Tuple2 com$foursquare$geo$quadtree$ShapefileSimplifier$$toIndex$1(Coordinate coord, ShapefileGeo.ShapeTrieNode node$1, double longChunk$1, double latChunk$1) {
        return new Tuple2.mcII.sp((int)((coord.x - node$1.nodeBounds().minLong()) / longChunk$1), (int)((coord.y - node$1.nodeBounds().minLat()) / latChunk$1));
    }

    public final void com$foursquare$geo$quadtree$ShapefileSimplifier$$gridifyList$1(ShapefileGeo.ShapeTrieNode node, int[] levels$1) {
        int nLongs = levels$1[node.nodeLevel()];
        int nLats = levels$1[node.nodeLevel()];
        double longChunk = node.nodeBounds().width() / (double)nLongs;
        double latChunk = node.nodeBounds().height() / (double)nLats;
        node.makeSubGrid(levels$1);
        node.subList().foreach((Function1)new Serializable(node, nLongs, nLats, longChunk, latChunk){
            public static final long serialVersionUID = 0L;
            public final ShapefileGeo.ShapeTrieNode node$1;
            private final int nLongs$1;
            private final int nLats$1;
            private final double longChunk$1;
            private final double latChunk$1;

            public final void apply(ShapefileGeo.ShapeLeafNode keyShape) {
                Geometry env = keyShape.shape().getEnvelope();
                Predef$.MODULE$.assert(env.isRectangle());
                Tuple2 tuple2 = ShapefileSimplifier$.MODULE$.com$foursquare$geo$quadtree$ShapefileSimplifier$$toIndex$1(env.getCoordinates()[ShapefileSimplifier$Coords$.MODULE$.BottomLeft().id()], this.node$1, this.longChunk$1, this.latChunk$1);
                if (tuple2 != null) {
                    Tuple2.mcII.sp sp2;
                    int minLongIdx = tuple2._1$mcI$sp();
                    int minLatIdx = tuple2._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(minLongIdx, minLatIdx);
                    int minLongIdx2 = sp3._1$mcI$sp();
                    int minLatIdx2 = sp3._2$mcI$sp();
                    Tuple2 tuple22 = ShapefileSimplifier$.MODULE$.com$foursquare$geo$quadtree$ShapefileSimplifier$$toIndex$1(env.getCoordinates()[ShapefileSimplifier$Coords$.MODULE$.TopRight().id()], this.node$1, this.longChunk$1, this.latChunk$1);
                    if (tuple22 != null) {
                        Tuple2.mcII.sp sp4;
                        int maxLongIdx = tuple22._1$mcI$sp();
                        int maxLatIdx = tuple22._2$mcI$sp();
                        Tuple2.mcII.sp sp5 = sp4 = new Tuple2.mcII.sp(maxLongIdx, maxLatIdx);
                        int maxLongIdx2 = sp5._1$mcI$sp();
                        int maxLatIdx2 = sp5._2$mcI$sp();
                        int mxLg = maxLongIdx2 >= this.nLongs$1 ? this.nLongs$1 - 1 : maxLongIdx2;
                        int mxLt = maxLatIdx2 >= this.nLats$1 ? this.nLats$1 - 1 : maxLatIdx2;
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(minLongIdx2), mxLg).foreach$mVc$sp((Function1)new Serializable(this, keyShape, minLatIdx2, mxLt){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$com$foursquare$geo$quadtree$ShapefileSimplifier$$gridifyList$1$2 $outer;
                            public final ShapefileGeo.ShapeLeafNode keyShape$1;
                            private final int minLatIdx$1;
                            private final int mxLt$1;

                            public final void apply(int longIdx) {
                                this.apply$mcVI$sp(longIdx);
                            }

                            public void apply$mcVI$sp(int longIdx) {
                                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.minLatIdx$1), this.mxLt$1).foreach$mVc$sp((Function1)new Serializable(this, longIdx){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$com$foursquare$geo$quadtree$ShapefileSimplifier$$gridifyList$1$2$$anonfun$apply$1 $outer;
                                    private final int longIdx$1;

                                    public final void apply(int latIdx) {
                                        this.apply$mcVI$sp(latIdx);
                                    }

                                    public void apply$mcVI$sp(int latIdx) {
                                        ShapefileGeo.ShapeTrieNode cell = ((ShapefileGeo.ShapeTrieNode[][])this.$outer.com$foursquare$geo$quadtree$ShapefileSimplifier$$anonfun$$anonfun$$$outer().node$1.subGrid().get())[this.longIdx$1][latIdx];
                                        Geometry validKeyShape = this.$outer.keyShape$1.shape().isValid() ? this.$outer.keyShape$1.shape() : this.$outer.keyShape$1.shape().buffer(0.0);
                                        try {
                                            if (cell.shape().intersects(validKeyShape)) {
                                                cell.subList_$eq((List<ShapefileGeo.ShapeLeafNode>)cell.subList().$colon$colon((Object)new ShapefileGeo.ShapeLeafNode((String)this.$outer.keyShape$1.keyValue().get(), cell.shape().intersection(validKeyShape))));
                                            }
                                            return;
                                        }
                                        catch (Throwable throwable) {
                                            Predef$.MODULE$.println((Object)cell.shape());
                                            Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)cell.shape().isValid()));
                                            Predef$.MODULE$.println((Object)this.$outer.keyShape$1);
                                            Predef$.MODULE$.println((Object)this.$outer.keyShape$1.shape());
                                            Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.keyShape$1.shape().isValid()));
                                            Predef$.MODULE$.println((Object)this.$outer.keyShape$1.shape().buffer(0.0));
                                            Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.keyShape$1.shape().buffer(0.0).isValid()));
                                            throw throwable;
                                        }
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.longIdx$1 = longIdx$1;
                                    }
                                });
                            }

                            public /* synthetic */ anonfun$com$foursquare$geo$quadtree$ShapefileSimplifier$$gridifyList$1$2 com$foursquare$geo$quadtree$ShapefileSimplifier$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.keyShape$1 = keyShape$1;
                                this.minLatIdx$1 = minLatIdx$1;
                                this.mxLt$1 = mxLt$1;
                            }
                        });
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.node$1 = node$1;
                this.nLongs$1 = nLongs$1;
                this.nLats$1 = nLats$1;
                this.longChunk$1 = longChunk$1;
                this.latChunk$1 = latChunk$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nLongs).foreach$mVc$sp((Function1)new Serializable(levels$1, node, nLats){
            public static final long serialVersionUID = 0L;
            public final int[] levels$1;
            public final ShapefileGeo.ShapeTrieNode node$1;
            private final int nLats$1;

            public final void apply(int longIdx) {
                this.apply$mcVI$sp(longIdx);
            }

            public void apply$mcVI$sp(int longIdx) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nLats$1).foreach$mVc$sp((Function1)new Serializable(this, longIdx){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$com$foursquare$geo$quadtree$ShapefileSimplifier$$gridifyList$1$1 $outer;
                    private final int longIdx$2;

                    public final void apply(int latIdx) {
                        this.apply$mcVI$sp(latIdx);
                    }

                    public void apply$mcVI$sp(int latIdx) {
                        ShapefileGeo.ShapeTrieNode cell = ((ShapefileGeo.ShapeTrieNode[][])this.$outer.node$1.subGrid().get())[this.longIdx$2][latIdx];
                        ShapefileSimplifier$.MODULE$.com$foursquare$geo$quadtree$ShapefileSimplifier$$gridifyList$1(cell, this.$outer.levels$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.longIdx$2 = longIdx$2;
                    }
                });
            }
            {
                this.levels$1 = levels$1;
                this.node$1 = node$1;
                this.nLats$1 = nLats$1;
            }
        });
        node.subList_$eq((List<ShapefileGeo.ShapeLeafNode>)Nil$.MODULE$);
    }

    public final void com$foursquare$geo$quadtree$ShapefileSimplifier$$addFeature$1(Geometry poly, String tz, String path, FeatureWriter writer$1) {
        SimpleFeature feat = (SimpleFeature)writer$1.next();
        feat.setAttributes(new Object[]{poly, tz, path});
        writer$1.write();
    }

    public final void com$foursquare$geo$quadtree$ShapefileSimplifier$$enumerateFeatures$1(ShapefileGeo.ShapeTrieNode cell, String path, FeatureWriter writer$1) {
        Option<String> option;
        block4: {
            Option<ShapefileGeo.ShapeTrieNode[][]> option2;
            block7: {
                block3: {
                    block6: {
                        block5: {
                            block2: {
                                option = cell.keyValue();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String tz = (String)some.x();
                                this.com$foursquare$geo$quadtree$ShapefileSimplifier$$addFeature$1(cell.shape(), tz, path, writer$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<String> option3 = option;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                            option2 = cell.subGrid();
                            if (!(option2 instanceof Some)) break block5;
                            Some some = (Some)option2;
                            ShapefileGeo.ShapeTrieNode[][] grid = (ShapefileGeo.ShapeTrieNode[][])some.x();
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cell.subGridSize()._1$mcI$sp()).foreach$mVc$sp((Function1)new Serializable(writer$1, cell, path, grid){
                                public static final long serialVersionUID = 0L;
                                public final FeatureWriter writer$1;
                                private final ShapefileGeo.ShapeTrieNode cell$1;
                                public final String path$1;
                                public final ShapefileGeo.ShapeTrieNode[][] grid$1;

                                public final void apply(int longIdx) {
                                    this.apply$mcVI$sp(longIdx);
                                }

                                public void apply$mcVI$sp(int longIdx) {
                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.cell$1.subGridSize()._2$mcI$sp()).foreach$mVc$sp((Function1)new Serializable(this, longIdx){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$com$foursquare$geo$quadtree$ShapefileSimplifier$$enumerateFeatures$1$1 $outer;
                                        private final int longIdx$3;

                                        public final void apply(int latIdx) {
                                            this.apply$mcVI$sp(latIdx);
                                        }

                                        public void apply$mcVI$sp(int latIdx) {
                                            ShapefileSimplifier$.MODULE$.com$foursquare$geo$quadtree$ShapefileSimplifier$$enumerateFeatures$1(this.$outer.grid$1[this.longIdx$3][latIdx], new StringBuilder().append((Object)this.$outer.path$1).append((Object)BoxesRunTime.boxToInteger((int)this.longIdx$3)).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)latIdx)).append((Object)";").toString(), this.$outer.writer$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.longIdx$3 = longIdx$3;
                                        }
                                    });
                                }
                                {
                                    this.writer$1 = writer$1;
                                    this.cell$1 = cell$1;
                                    this.path$1 = path$1;
                                    this.grid$1 = grid$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block6;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<ShapefileGeo.ShapeTrieNode[][]> option4 = option2;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                        cell.subList().foreach((Function1)new Serializable(writer$1, path){
                            public static final long serialVersionUID = 0L;
                            private final FeatureWriter writer$1;
                            private final String path$1;

                            public final void apply(ShapefileGeo.ShapeLeafNode keyShape) {
                                ShapefileSimplifier$.MODULE$.com$foursquare$geo$quadtree$ShapefileSimplifier$$addFeature$1(keyShape.shape(), (String)keyShape.keyValue().get(), this.path$1, this.writer$1);
                            }
                            {
                                this.writer$1 = writer$1;
                                this.path$1 = path$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    private ShapefileSimplifier$() {
        MODULE$ = this;
        this.defaultLevels = new int[]{1000, 10, 4, 4};
    }
}

