/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.api.MchApi;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.mch.APPPayRequest;
import com.foxinmy.weixin4j.payment.mch.JSAPIPayRequest;
import com.foxinmy.weixin4j.payment.mch.MICROPayRequest;
import com.foxinmy.weixin4j.payment.mch.MchPayPackage;
import com.foxinmy.weixin4j.payment.mch.MchPayRequest;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.payment.mch.NATIVEPayRequest;
import com.foxinmy.weixin4j.payment.mch.NativePayResponse;
import com.foxinmy.weixin4j.payment.mch.OpenIdResult;
import com.foxinmy.weixin4j.payment.mch.Order;
import com.foxinmy.weixin4j.payment.mch.PrePay;
import com.foxinmy.weixin4j.payment.mch.RefundRecord;
import com.foxinmy.weixin4j.payment.mch.RefundResult;
import com.foxinmy.weixin4j.payment.mch.WAPPayRequest;
import com.foxinmy.weixin4j.type.CurrencyType;
import com.foxinmy.weixin4j.type.IdQuery;
import com.foxinmy.weixin4j.type.IdType;
import com.foxinmy.weixin4j.type.SignType;
import com.foxinmy.weixin4j.type.TarType;
import com.foxinmy.weixin4j.type.TradeType;
import com.foxinmy.weixin4j.type.mch.BillType;
import com.foxinmy.weixin4j.type.mch.RefundAccountType;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.DateUtil;
import com.foxinmy.weixin4j.util.DigestUtil;
import com.foxinmy.weixin4j.util.IOUtil;
import com.foxinmy.weixin4j.util.MapUtil;
import com.foxinmy.weixin4j.util.RandomUtil;
import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.xml.ListsuffixResultDeserializer;
import com.foxinmy.weixin4j.xml.XmlStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PayApi
extends MchApi {
    public PayApi(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }

    public PrePay createPrePay(MchPayPackage payPackage) throws WeixinException {
        super.declareMerchant(payPackage);
        payPackage.setSign(this.weixinSignature.sign(payPackage));
        String payJsRequestXml = XmlStream.toXML(payPackage);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("order_create_uri"), payJsRequestXml);
        return response.getAsObject(new TypeReference<PrePay>(){});
    }

    public MchPayRequest createPayRequest(MchPayPackage payPackage) throws WeixinException {
        if (StringUtil.isBlank(payPackage.getTradeType())) {
            throw new WeixinException("tradeType not be empty");
        }
        String tradeType = payPackage.getTradeType().toUpperCase();
        if (TradeType.MICROPAY.name().equals(tradeType)) {
            MchPayPackage _payPackage = new MchPayPackage(payPackage.getBody(), payPackage.getDetail(), payPackage.getOutTradeNo(), DateUtil.formatFee2Yuan(payPackage.getTotalFee()), null, null, payPackage.getCreateIp(), null, null, payPackage.getAuthCode(), null, payPackage.getAttach(), null, null, payPackage.getGoodsTag(), payPackage.getLimitPay(), payPackage.getSubAppId());
            super.declareMerchant(_payPackage);
            _payPackage.setSign(this.weixinSignature.sign(_payPackage));
            String para = XmlStream.toXML(_payPackage);
            WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("micropay_uri"), para);
            MICROPayRequest microPayRequest = response.getAsObject(new TypeReference<MICROPayRequest>(){});
            microPayRequest.setPaymentAccount(this.weixinAccount);
            return microPayRequest;
        }
        PrePay prePay = this.createPrePay(payPackage);
        if (TradeType.APP.name().equals(tradeType)) {
            return new APPPayRequest(prePay.getPrepayId(), this.weixinAccount);
        }
        if (TradeType.JSAPI.name().equals(tradeType)) {
            return new JSAPIPayRequest(prePay.getPrepayId(), this.weixinAccount);
        }
        if (TradeType.NATIVE.name().equals(tradeType)) {
            return new NATIVEPayRequest(prePay.getPrepayId(), prePay.getPayUrl(), this.weixinAccount);
        }
        if (TradeType.MWEB.name().equals(tradeType)) {
            return new WAPPayRequest(prePay.getPrepayId(), prePay.getPayUrl(), this.weixinAccount);
        }
        throw new WeixinException("unknown tradeType:" + tradeType);
    }

    public MchPayRequest createJSPayRequest(String openId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        MchPayPackage payPackage = new MchPayPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.JSAPI, openId, null, null, attach);
        return this.createPayRequest(payPackage);
    }

    public String createAddressRequestJSON(String url, String oauthToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", this.weixinAccount.getId());
        map.put("timeStamp", DateUtil.timestamp2string());
        map.put("nonceStr", RandomUtil.generateString(16));
        map.put("url", url);
        map.put("accessToken", oauthToken);
        String sign = DigestUtil.SHA1(MapUtil.toJoinString(map, false, true));
        map.remove("url");
        map.remove("accessToken");
        map.put("scope", "jsapi_address");
        map.put("signType", SignType.SHA1.name().toLowerCase());
        map.put("addrSign", sign);
        return JSON.toJSONString(map);
    }

    public String createNativePayRequest(String productId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String timestamp = DateUtil.timestamp2string();
        String noncestr = RandomUtil.generateString(16);
        map.put("appid", this.weixinAccount.getId());
        map.put("mch_id", this.weixinAccount.getMchId());
        map.put("time_stamp", timestamp);
        map.put("nonce_str", noncestr);
        map.put("product_id", productId);
        String sign = this.weixinSignature.sign(map);
        return String.format(this.getRequestUri("native_pay_uri"), sign, this.weixinAccount.getId(), this.weixinAccount.getMchId(), productId, timestamp, noncestr);
    }

    public NativePayResponse createNativePayResponse(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        MchPayPackage payPackage = new MchPayPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.NATIVE, null, null, productId, attach);
        PrePay prePay = this.createPrePay(payPackage);
        return new NativePayResponse(this.weixinAccount, prePay.getPrepayId());
    }

    public MchPayRequest createNativePayRequest(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        MchPayPackage payPackage = new MchPayPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.NATIVE, null, null, productId, attach);
        return this.createPayRequest(payPackage);
    }

    public MchPayRequest createAppPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        MchPayPackage payPackage = new MchPayPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.APP, null, null, null, attach);
        return this.createPayRequest(payPackage);
    }

    public MchPayRequest createWapPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        MchPayPackage payPackage = new MchPayPackage(body, outTradeNo, totalFee, notifyUrl, createIp, TradeType.MWEB, null, null, null, attach);
        return this.createPayRequest(payPackage);
    }

    public MchPayRequest createMicroPayRequest(String authCode, String body, String outTradeNo, double totalFee, String createIp, String attach) throws WeixinException {
        MchPayPackage payPackage = new MchPayPackage(body, outTradeNo, totalFee, null, createIp, TradeType.MICROPAY, null, authCode, null, attach);
        return this.createPayRequest(payPackage);
    }

    public Order queryOrder(IdQuery idQuery) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(idQuery);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("order_query_uri"), param);
        return ListsuffixResultDeserializer.deserialize(response.getAsString(), Order.class);
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee, double refundFee, CurrencyType refundFeeType, String opUserId, String refundDesc, RefundAccountType refundAccountType) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(idQuery);
        map.put("out_refund_no", outRefundNo);
        map.put("total_fee", Integer.toString(DateUtil.formatYuan2Fen(totalFee)));
        map.put("refund_fee", Integer.toString(DateUtil.formatYuan2Fen(refundFee)));
        if (StringUtil.isBlank(opUserId)) {
            opUserId = this.weixinAccount.getMchId();
        }
        map.put("op_user_id", opUserId);
        if (refundFeeType == null) {
            refundFeeType = CurrencyType.CNY;
        }
        if (refundAccountType == null) {
            refundAccountType = RefundAccountType.REFUND_SOURCE_UNSETTLED_FUNDS;
        }
        if (StringUtil.isNotBlank(refundDesc)) {
            map.put("refund_desc", refundDesc);
        }
        map.put("refund_fee_type", refundFeeType.name());
        map.put("refund_account", refundAccountType.name());
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.getWeixinSSLExecutor().post(this.getRequestUri("refund_apply_uri"), param);
        return response.getAsObject(new TypeReference<RefundResult>(){});
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee) throws WeixinException {
        return this.applyRefund(idQuery, outRefundNo, totalFee, totalFee, null, null, null, null);
    }

    public MerchantResult reverseOrder(IdQuery idQuery) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(idQuery);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.getWeixinSSLExecutor().post(this.getRequestUri("order_reverse_uri"), param);
        return response.getAsObject(new TypeReference<MerchantResult>(){});
    }

    public String getShorturl(String url) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        try {
            map.put("long_url", URLEncoder.encode(url, Consts.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("longurl_convert_uri"), param);
        map = XmlStream.xml2map(response.getAsString());
        return map.get("short_url");
    }

    public MerchantResult closeOrder(String outTradeNo) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(new IdQuery(outTradeNo, IdType.TRADENO));
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("order_close_uri"), param);
        return response.getAsObject(new TypeReference<MerchantResult>(){});
    }

    public void downloadBill(Date billDate, BillType billType, OutputStream outputStream, TarType tarType) throws WeixinException {
        if (billDate == null) {
            Calendar now = Calendar.getInstance();
            now.add(5, -1);
            billDate = now.getTime();
        }
        if (billType == null) {
            billType = BillType.ALL;
        }
        String formatBillDate = DateUtil.fortmat2yyyyMMdd(billDate);
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("bill_date", formatBillDate);
        map.put("bill_type", billType.name());
        if (tarType != null) {
            map.put("tar_type", tarType.name());
        }
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("downloadbill_uri"), param);
        if (TarType.GZIP == tarType) {
            try {
                IOUtil.copy(response.getBody(), outputStream);
            }
            catch (IOException e) {}
        } else {
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter(outputStream, Consts.UTF_8));
                reader = new BufferedReader(new InputStreamReader(response.getBody(), Consts.UTF_8));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (IOException e) {
                throw new WeixinException(e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ignore) {}
            }
        }
    }

    public RefundRecord queryRefund(IdQuery idQuery) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(idQuery);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("refund_query_uri"), param);
        return ListsuffixResultDeserializer.deserialize(response.getAsString(), RefundRecord.class);
    }

    public XmlResult reportInterface(String interfaceUrl, int executeTime, String outTradeNo, String ip, Date time, XmlResult returnXml) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("interface_url", interfaceUrl);
        map.put("execute_time_", Integer.toString(executeTime));
        map.put("out_trade_no", outTradeNo);
        map.put("user_ip", ip);
        map.put("time", DateUtil.fortmat2yyyyMMddHHmmss(time));
        map.putAll((Map)JSON.toJSON((Object)returnXml));
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("interface_report_uri"), param);
        return response.getAsXml();
    }

    public OpenIdResult authCode2openId(String authCode) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("auth_code", authCode);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("authcode_openid_uri"), param);
        return response.getAsObject(new TypeReference<OpenIdResult>(){});
    }
}

