/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpVersion
implements Comparable<HttpVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\S+)/(\\d+)\\.(\\d+)");
    public static final String HTTP_1_0_STRING = "HTTP/1.0";
    public static final String HTTP_1_1_STRING = "HTTP/1.1";
    public static final HttpVersion HTTP_1_0 = new HttpVersion("HTTP", 1, 0, false);
    public static final HttpVersion HTTP_1_1 = new HttpVersion("HTTP", 1, 1, true);
    private final String protocol;
    private final int major;
    private final int minor;
    private final boolean keepAlive;
    private final String text;

    public HttpVersion(String text, boolean keepAlive) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if ((text = text.trim().toUpperCase()).isEmpty()) {
            throw new IllegalArgumentException("empty text");
        }
        Matcher m = VERSION_PATTERN.matcher(text);
        if (!m.matches()) {
            throw new IllegalArgumentException("invalid version format: " + text);
        }
        this.protocol = m.group(1);
        this.major = Integer.parseInt(m.group(2));
        this.minor = Integer.parseInt(m.group(3));
        this.keepAlive = keepAlive;
        this.text = this.protocol + '/' + this.major + '.' + this.minor;
    }

    public HttpVersion(String protocol, int major, int minor, boolean keepAlive) {
        this.protocol = protocol;
        this.major = major;
        this.minor = minor;
        this.keepAlive = keepAlive;
        this.text = protocol + '/' + major + '.' + minor;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.getText();
    }

    public int hashCode() {
        return (this.protocol.hashCode() * 31 + this.major) * 31 + this.minor;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpVersion)) {
            return false;
        }
        HttpVersion that = (HttpVersion)o;
        return this.minor == that.minor && this.major == that.major && this.protocol.equals(that.protocol);
    }

    @Override
    public int compareTo(HttpVersion o) {
        int v = this.protocol.compareTo(o.protocol);
        if (v != 0) {
            return v;
        }
        v = this.major - o.major;
        if (v != 0) {
            return v;
        }
        return this.minor - o.minor;
    }
}

