/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.type.ButtonType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Button
implements Serializable {
    private static final long serialVersionUID = -6422234732203854866L;
    private String name;
    private String type;
    private String content;
    @JSONField(serialize=false, deserialize=false)
    private Object extra;
    private String appid;
    private String pagepath;
    @JSONField(name="sub_button")
    private List<Button> subs;

    protected Button() {
        this.subs = new ArrayList<Button>();
    }

    public Button(String name, Button ... subButtons) {
        this.name = name;
        this.subs = new ArrayList<Button>(Arrays.asList(subButtons));
    }

    public Button(String name, String content, ButtonType type) {
        this.name = name;
        this.content = content;
        this.type = type.name();
        this.subs = new ArrayList<Button>();
    }

    public Button(String name, String url, String appid, String pagepath) {
        this.name = name;
        this.content = url;
        this.appid = appid;
        this.pagepath = pagepath;
        this.type = ButtonType.miniprogram.name();
        this.subs = new ArrayList<Button>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setType(ButtonType type) {
        this.type = type.name();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getPagepath() {
        return this.pagepath;
    }

    public void setPagepath(String pagepath) {
        this.pagepath = pagepath;
    }

    public List<Button> getSubs() {
        return this.subs;
    }

    public void setSubs(List<Button> subs) {
        this.subs = subs;
    }

    public Button pushSub(Button btn) {
        this.subs.add(btn);
        return this;
    }

    public String toString() {
        return "Button [name=" + this.name + ", type=" + this.type + ", content=" + this.content + ", extra=" + this.extra + ", appid=" + this.appid + ", pagepath=" + this.pagepath + ", subs=" + this.subs + "]";
    }
}

