/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.qr;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.model.card.CardQR;
import com.foxinmy.weixin4j.type.QRType;
import java.io.Serializable;

public class QRParameter
implements Serializable {
    private static final long serialVersionUID = 6611187606558274253L;
    @JSONField(name="action_name")
    private QRType qrType;
    @JSONField(name="expire_seconds")
    private Integer expireSeconds;
    @JSONField(serialize=false)
    private String sceneValue;
    @JSONField(name="action_info")
    private JSONObject sceneContent;

    private QRParameter(QRType qrType, Integer expireSeconds, String sceneValue, JSONObject sceneContent) {
        this.qrType = qrType;
        this.expireSeconds = expireSeconds;
        this.sceneValue = sceneValue;
        this.sceneContent = sceneContent;
    }

    public Integer getExpireSeconds() {
        return this.expireSeconds;
    }

    public QRType getQrType() {
        return this.qrType;
    }

    public String getSceneValue() {
        return this.sceneValue;
    }

    public JSONObject getSceneContent() {
        return this.sceneContent;
    }

    public static QRParameter createTemporaryQR(int expireSeconds, long sceneValue) {
        JSONObject sceneContent = new JSONObject();
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)sceneValue);
        sceneContent.put("scene", (Object)scene);
        return new QRParameter(QRType.QR_SCENE, expireSeconds, Long.toString(sceneValue), sceneContent);
    }

    public static QRParameter createTemporaryQR(int expireSeconds, String sceneValue) {
        JSONObject sceneContent = new JSONObject();
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)sceneValue);
        sceneContent.put("scene", (Object)scene);
        return new QRParameter(QRType.QR_STR_SCENE, expireSeconds, sceneValue, sceneContent);
    }

    public static QRParameter createPermanenceQR(int sceneValue) {
        JSONObject sceneContent = new JSONObject();
        JSONObject scene = new JSONObject();
        scene.put("scene_id", (Object)sceneValue);
        sceneContent.put("scene", (Object)scene);
        return new QRParameter(QRType.QR_LIMIT_SCENE, null, Integer.toString(sceneValue), sceneContent);
    }

    public static QRParameter createPermanenceQR(String sceneValue) {
        JSONObject sceneContent = new JSONObject();
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)sceneValue);
        sceneContent.put("scene", (Object)scene);
        return new QRParameter(QRType.QR_LIMIT_STR_SCENE, null, sceneValue, sceneContent);
    }

    public static QRParameter createCardCouponQR(Integer expireSeconds, CardQR ... cardQRs) {
        QRType qrType = QRType.QR_CARD;
        JSONObject sceneContent = new JSONObject();
        StringBuilder sceneValue = new StringBuilder();
        sceneValue.append(cardQRs[0].getSceneValue());
        if (cardQRs.length > 1) {
            qrType = QRType.QR_MULTIPLE_CARD;
            JSONObject multipleCard = new JSONObject();
            multipleCard.put("card_list", (Object)cardQRs);
            sceneContent.put("multiple_card", (Object)multipleCard);
            for (int i = 1; i < cardQRs.length; ++i) {
                sceneValue.append(",").append(cardQRs[i].getSceneValue());
            }
        } else {
            sceneContent.put("card", (Object)cardQRs[0]);
        }
        return new QRParameter(qrType, expireSeconds, sceneValue.toString(), sceneContent);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expireSeconds == null ? 0 : this.expireSeconds.hashCode());
        result = 31 * result + (this.qrType == null ? 0 : this.qrType.hashCode());
        result = 31 * result + (this.sceneContent == null ? 0 : this.sceneContent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QRParameter other = (QRParameter)obj;
        if (this.expireSeconds == null ? other.expireSeconds != null : !this.expireSeconds.equals(other.expireSeconds)) {
            return false;
        }
        if (this.qrType != other.qrType) {
            return false;
        }
        return !(this.sceneContent == null ? other.sceneContent != null : !this.sceneContent.equals((Object)other.sceneContent));
    }

    public String toString() {
        return "QRParameter [qrType=" + (Object)((Object)this.qrType) + ", expireSeconds=" + this.expireSeconds + ", sceneContent=" + this.sceneContent + "]";
    }
}

