/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment;

import com.alibaba.fastjson.JSON;
import com.foxinmy.weixin4j.api.CashApi;
import com.foxinmy.weixin4j.api.CouponApi;
import com.foxinmy.weixin4j.api.CustomsApi;
import com.foxinmy.weixin4j.api.PayApi;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.model.paging.Pageable;
import com.foxinmy.weixin4j.payment.coupon.CouponDetail;
import com.foxinmy.weixin4j.payment.coupon.CouponResult;
import com.foxinmy.weixin4j.payment.coupon.CouponStock;
import com.foxinmy.weixin4j.payment.mch.CorpPayment;
import com.foxinmy.weixin4j.payment.mch.CorpPaymentRecord;
import com.foxinmy.weixin4j.payment.mch.CorpPaymentResult;
import com.foxinmy.weixin4j.payment.mch.CustomsOrder;
import com.foxinmy.weixin4j.payment.mch.CustomsOrderRecord;
import com.foxinmy.weixin4j.payment.mch.CustomsOrderResult;
import com.foxinmy.weixin4j.payment.mch.MchPayPackage;
import com.foxinmy.weixin4j.payment.mch.MchPayRequest;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.payment.mch.NativePayResponse;
import com.foxinmy.weixin4j.payment.mch.OpenIdResult;
import com.foxinmy.weixin4j.payment.mch.Order;
import com.foxinmy.weixin4j.payment.mch.PrePay;
import com.foxinmy.weixin4j.payment.mch.Redpacket;
import com.foxinmy.weixin4j.payment.mch.RedpacketRecord;
import com.foxinmy.weixin4j.payment.mch.RedpacketSendResult;
import com.foxinmy.weixin4j.payment.mch.RefundRecord;
import com.foxinmy.weixin4j.payment.mch.RefundResult;
import com.foxinmy.weixin4j.payment.mch.SettlementRecord;
import com.foxinmy.weixin4j.sign.WeixinSignature;
import com.foxinmy.weixin4j.type.CurrencyType;
import com.foxinmy.weixin4j.type.CustomsCity;
import com.foxinmy.weixin4j.type.IdQuery;
import com.foxinmy.weixin4j.type.TarType;
import com.foxinmy.weixin4j.type.mch.BillType;
import com.foxinmy.weixin4j.type.mch.RefundAccountType;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;

public class WeixinPayProxy {
    private final PayApi payApi;
    private final CouponApi couponApi;
    private final CashApi cashApi;
    private final CustomsApi customsApi;
    private final WeixinPayAccount weixinPayAccount;
    public static final String VERSION = "1.7.8";

    public WeixinPayProxy() {
        this((WeixinPayAccount)JSON.parseObject((String)Weixin4jConfigUtil.getValue("account"), WeixinPayAccount.class));
    }

    public WeixinPayProxy(WeixinPayAccount weixinPayAccount) {
        if (weixinPayAccount == null) {
            throw new IllegalArgumentException("weixinPayAccount must not be empty");
        }
        this.weixinPayAccount = weixinPayAccount;
        this.payApi = new PayApi(weixinPayAccount);
        this.couponApi = new CouponApi(weixinPayAccount);
        this.cashApi = new CashApi(weixinPayAccount);
        this.customsApi = new CustomsApi(weixinPayAccount);
    }

    public WeixinPayAccount getWeixinPayAccount() {
        return this.weixinPayAccount;
    }

    public WeixinSignature getWeixinSignature() {
        return this.payApi.getWeixinSignature();
    }

    public PrePay createPrePay(MchPayPackage payPackage) throws WeixinException {
        return this.payApi.createPrePay(payPackage);
    }

    public MchPayRequest createPayRequest(MchPayPackage payPackage) throws WeixinException {
        return this.payApi.createPayRequest(payPackage);
    }

    public MchPayRequest createJSPayRequest(String openId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createJSPayRequest(openId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public String createAddressRequestJSON(String url, String oauthToken) {
        return this.payApi.createAddressRequestJSON(url, oauthToken);
    }

    public String createNativePayRequest(String productId) {
        return this.payApi.createNativePayRequest(productId);
    }

    public NativePayResponse createNativePayResponse(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createNativePayResponse(productId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MchPayRequest createNativePayRequest(String productId, String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createNativePayRequest(productId, body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MchPayRequest createAppPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createAppPayRequest(body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MchPayRequest createWapPayRequest(String body, String outTradeNo, double totalFee, String notifyUrl, String createIp, String attach) throws WeixinException {
        return this.payApi.createWapPayRequest(body, outTradeNo, totalFee, notifyUrl, createIp, attach);
    }

    public MchPayRequest createMicroPayRequest(String authCode, String body, String outTradeNo, double totalFee, String createIp, String attach) throws WeixinException {
        return this.payApi.createMicroPayRequest(authCode, body, outTradeNo, totalFee, createIp, attach);
    }

    public Order queryOrder(IdQuery idQuery) throws WeixinException {
        return this.payApi.queryOrder(idQuery);
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee, double refundFee, CurrencyType refundFeeType, String opUserId, String refundDesc, RefundAccountType refundAccountType) throws WeixinException {
        return this.payApi.applyRefund(idQuery, outRefundNo, totalFee, refundFee, refundFeeType, opUserId, refundDesc, refundAccountType);
    }

    public RefundResult applyRefund(IdQuery idQuery, String outRefundNo, double totalFee) throws WeixinException {
        return this.payApi.applyRefund(idQuery, outRefundNo, totalFee);
    }

    public RefundRecord queryRefund(IdQuery idQuery) throws WeixinException {
        return this.payApi.queryRefund(idQuery);
    }

    public void downloadBill(Date billDate, BillType billType, OutputStream outputStream, TarType tarType) throws WeixinException {
        this.payApi.downloadBill(billDate, billType, outputStream, tarType);
    }

    public MerchantResult reverseOrder(IdQuery idQuery) throws WeixinException {
        return this.payApi.reverseOrder(idQuery);
    }

    public MerchantResult closeOrder(String outTradeNo) throws WeixinException {
        return this.payApi.closeOrder(outTradeNo);
    }

    public String getPayShorturl(String url) throws WeixinException {
        return this.payApi.getShorturl(url);
    }

    public XmlResult reportInterface(String interfaceUrl, int executeTime, String outTradeNo, String ip, Date time, XmlResult returnXml) throws WeixinException {
        return this.payApi.reportInterface(interfaceUrl, executeTime, outTradeNo, ip, time, returnXml);
    }

    public CouponResult sendCoupon(String couponStockId, String partnerTradeNo, String openId, String opUserId) throws WeixinException {
        return this.couponApi.sendCoupon(couponStockId, partnerTradeNo, openId, opUserId);
    }

    public CouponStock queryCouponStock(String couponStockId) throws WeixinException {
        return this.couponApi.queryCouponStock(couponStockId);
    }

    public CouponDetail queryCouponDetail(String openId, String couponId, String stockId) throws WeixinException {
        return this.couponApi.queryCouponDetail(openId, couponId, stockId);
    }

    public RedpacketSendResult sendRedpack(Redpacket redpacket) throws WeixinException {
        return this.cashApi.sendRedpack(redpacket);
    }

    public List<Future<RedpacketSendResult>> sendRedpacks(Redpacket ... redpackets) {
        return this.cashApi.sendRedpacks(redpackets);
    }

    public RedpacketRecord queryRedpack(String outTradeNo) throws WeixinException {
        return this.cashApi.queryRedpack(outTradeNo);
    }

    public CorpPaymentResult sendCorpPayment(CorpPayment payment) throws WeixinException {
        return this.cashApi.sendCorpPayment(payment);
    }

    public CorpPaymentRecord queryCorpPayment(String outTradeNo) throws WeixinException {
        return this.cashApi.queryCorpPayment(outTradeNo);
    }

    public OpenIdResult authCode2openId(String authCode) throws WeixinException {
        return this.payApi.authCode2openId(authCode);
    }

    public SettlementRecord querySettlement(boolean status, Pageable pageable, Date start, Date end) throws WeixinException {
        return this.cashApi.querySettlement(status, pageable, start, end);
    }

    public double queryExchageRate(CurrencyType currencyType, Date date) throws WeixinException {
        return this.cashApi.queryExchageRate(currencyType, date);
    }

    public CustomsOrderResult declareCustomsOrder(CustomsOrder customsOrder) throws WeixinException {
        return this.customsApi.declareCustomsOrder(customsOrder);
    }

    public CustomsOrderRecord queryCustomsOrder(IdQuery idQuery, CustomsCity customsCity) throws WeixinException {
        return this.customsApi.queryCustomsOrder(idQuery, customsCity);
    }
}

