/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.coupon;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.type.mch.CouponStatus;
import com.foxinmy.weixin4j.type.mch.CouponStockType;
import com.foxinmy.weixin4j.type.mch.CouponType;
import com.foxinmy.weixin4j.util.DateUtil;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CouponDetail
extends MerchantResult {
    private static final long serialVersionUID = -311265355895457070L;
    @XmlElement(name="coupon_stock_id")
    @JSONField(name="coupon_stock_id")
    private String couponStockId;
    @XmlElement(name="coupon_stock_type")
    @JSONField(name="coupon_stock_type")
    private int couponStockType;
    @XmlElement(name="coupon_id")
    @JSONField(name="coupon_id")
    private String couponId;
    @XmlElement(name="coupon_value")
    @JSONField(name="coupon_value")
    private int couponValue;
    @XmlElement(name="coupon_mininum")
    @JSONField(name="coupon_mininum")
    private int couponMininum;
    @XmlElement(name="coupon_name")
    @JSONField(name="coupon_name")
    private String couponName;
    @XmlElement(name="coupon_state")
    @JSONField(name="coupon_state")
    private int couponStatus;
    @XmlElement(name="coupon_type")
    @JSONField(name="coupon_type")
    private int couponType;
    @XmlElement(name="coupon_desc")
    @JSONField(name="coupon_desc")
    private String couponDesc;
    @XmlElement(name="coupon_use_value")
    @JSONField(name="coupon_use_value")
    private int couponUseValue;
    @XmlElement(name="coupon_remain_value")
    @JSONField(name="coupon_remain_value")
    private int couponRemainValue;
    @XmlElement(name="begin_time")
    @JSONField(name="begin_time")
    private String beginTime;
    @XmlElement(name="end_time")
    @JSONField(name="end_time")
    private String endTime;
    @XmlElement(name="send_time")
    @JSONField(name="send_time")
    private String sendTime;
    @XmlElement(name="use_time")
    @JSONField(name="use_time")
    private String useTime;
    @XmlElement(name="trade_no")
    @JSONField(name="trade_no")
    private String tradeNo;
    @XmlElement(name="consumer_mch_id")
    @JSONField(name="consumer_mch_id")
    private String consumerMchId;
    @XmlElement(name="consumer_mch_name")
    @JSONField(name="consumer_mch_name")
    private String consumerMchName;
    @XmlElement(name="consumer_mch_appid")
    @JSONField(name="consumer_mch_appid")
    private String consumerMchAppid;
    @XmlElement(name="send_source")
    @JSONField(name="send_source")
    private String sendSource;
    @XmlElement(name="is_partial_use")
    @JSONField(name="is_partial_use")
    private int isPartialUse;

    public String getCouponStockId() {
        return this.couponStockId;
    }

    public int getCouponStockType() {
        return this.couponStockType;
    }

    @JSONField(serialize=false)
    public CouponStockType getFormatCouponStockType() {
        for (CouponStockType couponStockType : CouponStockType.values()) {
            if (couponStockType.getVal() != this.couponStockType) continue;
            return couponStockType;
        }
        return null;
    }

    public String getCouponId() {
        return this.couponId;
    }

    public int getCouponValue() {
        return this.couponValue;
    }

    @JSONField(serialize=false)
    public double getFormatCouponValue() {
        return (double)this.couponValue / 100.0;
    }

    public int getCouponMininum() {
        return this.couponMininum;
    }

    @JSONField(serialize=false)
    public double getFormatCouponMininum() {
        return (double)this.couponMininum / 100.0;
    }

    public String getCouponName() {
        return this.couponName;
    }

    public int getCouponStatus() {
        return this.couponStatus;
    }

    @JSONField(serialize=false)
    public CouponStatus getFormatCouponStatus() {
        for (CouponStatus couponStatus : CouponStatus.values()) {
            if (couponStatus.getVal() != this.couponStatus) continue;
            return couponStatus;
        }
        return null;
    }

    public int getCouponType() {
        return this.couponType;
    }

    @JSONField(deserialize=false, serialize=false)
    public CouponType getFormatCouponType() {
        for (CouponType couponType : CouponType.values()) {
            if (couponType.getVal() != this.couponType) continue;
            return couponType;
        }
        return null;
    }

    public String getCouponDesc() {
        return this.couponDesc;
    }

    public int getCouponUseValue() {
        return this.couponUseValue;
    }

    @JSONField(serialize=false)
    public double getFormatCouponUseValue() {
        return (double)this.couponUseValue / 100.0;
    }

    public int getCouponRemainValue() {
        return this.couponRemainValue;
    }

    @JSONField(serialize=false)
    public double getFormatCouponRemainValue() {
        return (double)this.couponRemainValue / 100.0;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    @JSONField(serialize=false)
    public Date getFormatBeginTime() {
        return this.beginTime != null ? DateUtil.parse2yyyyMMddHHmmss(this.beginTime) : null;
    }

    public String getEndTime() {
        return this.endTime;
    }

    @JSONField(serialize=false)
    public Date getFormatEndTime() {
        return this.endTime != null ? DateUtil.parse2yyyyMMddHHmmss(this.endTime) : null;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    @JSONField(serialize=false)
    public Date getFormatSendTime() {
        return this.sendTime != null ? DateUtil.parse2yyyyMMddHHmmss(this.sendTime) : null;
    }

    public String getUseTime() {
        return this.useTime;
    }

    @JSONField(serialize=false)
    public Date getFormatUseTime() {
        return this.useTime != null ? DateUtil.parse2yyyyMMddHHmmss(this.useTime) : null;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public String getConsumerMchId() {
        return this.consumerMchId;
    }

    public String getConsumerMchName() {
        return this.consumerMchName;
    }

    public String getConsumerMchAppid() {
        return this.consumerMchAppid;
    }

    public String getSendSource() {
        return this.sendSource;
    }

    public int getIsPartialUse() {
        return this.isPartialUse;
    }

    @JSONField(serialize=false)
    public boolean getFormatIsPartialUse() {
        return this.isPartialUse == 1;
    }

    @Override
    public String toString() {
        return "CouponDetail [couponStockId=" + this.couponStockId + ", couponStockType=" + (Object)((Object)this.getFormatCouponStockType()) + ", couponId=" + this.couponId + ", couponValue=" + this.getFormatCouponValue() + ", couponMininum=" + this.getFormatCouponMininum() + ", couponName=" + this.couponName + ", couponStatus=" + this.getCouponStatus() + ", couponType=" + (Object)((Object)this.getFormatCouponType()) + ", couponDesc=" + this.couponDesc + ", couponUseValue=" + this.getFormatCouponUseValue() + ", couponRemainValue=" + this.getFormatCouponRemainValue() + ", beginTime=" + this.getFormatBeginTime() + ", endTime=" + this.getFormatEndTime() + ", sendTime=" + this.getFormatSendTime() + ", useTime=" + this.getFormatUseTime() + ", tradeNo=" + this.tradeNo + ", consumerMchId=" + this.consumerMchId + ", consumerMchName=" + this.consumerMchName + ", consumerMchAppid=" + this.consumerMchAppid + ", sendSource=" + this.sendSource + ", isPartialUse=" + this.getFormatIsPartialUse() + ", " + super.toString() + "]";
    }
}

