/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.coupon.RefundCouponInfo;
import com.foxinmy.weixin4j.type.mch.CouponType;
import com.foxinmy.weixin4j.type.mch.RefundChannel;
import com.foxinmy.weixin4j.type.mch.RefundStatus;
import com.foxinmy.weixin4j.util.DateUtil;
import com.foxinmy.weixin4j.xml.ListsuffixResult;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RefundDetail
implements Serializable {
    private static final long serialVersionUID = 1402738803019986864L;
    @XmlElement(name="out_refund_no")
    @JSONField(name="out_refund_no")
    private String outRefundNo;
    @XmlElement(name="refund_id")
    @JSONField(name="refund_id")
    private String refundId;
    @XmlElement(name="refund_channel")
    @JSONField(name="refund_channel")
    private String refundChannel;
    @XmlElement(name="refund_fee")
    @JSONField(name="refund_fee")
    private int refundFee;
    @XmlElement(name="refund_status")
    @JSONField(name="refund_status")
    private String refundStatus;
    @XmlElement(name="settlement_refund_fee")
    @JSONField(name="settlement_refund_fee")
    private Integer settlementRefundFee;
    @XmlElement(name="coupon_refund_fee")
    @JSONField(name="coupon_refund_fee")
    private Integer couponRefundFee;
    @XmlElement(name="coupon_refund_count")
    @JSONField(name="coupon_refund_count")
    private Integer couponRefundCount;
    @XmlElement(name="coupon_type")
    @JSONField(name="coupon_type")
    private String couponType;
    @XmlElement(name="refund_recv_accout")
    @JSONField(name="refund_recv_accout")
    private String refundRecvAccout;
    @XmlElement(name="refund_success_time")
    @JSONField(name="refund_success_time")
    private String refundSuccessTime;
    @ListsuffixResult
    private List<RefundCouponInfo> couponList;

    protected RefundDetail() {
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public String getRefundChannel() {
        return this.refundChannel;
    }

    @JSONField(serialize=false)
    public RefundChannel getFormatRefundChannel() {
        return this.refundChannel != null ? RefundChannel.valueOf(this.refundChannel.toUpperCase()) : null;
    }

    public int getRefundFee() {
        return this.refundFee;
    }

    public String getRefundStatus() {
        return this.refundStatus;
    }

    @JSONField(serialize=false)
    public RefundStatus getFormatRefundStatus() {
        return this.refundStatus != null ? RefundStatus.valueOf(this.refundStatus.toUpperCase()) : null;
    }

    public List<RefundCouponInfo> getCouponList() {
        return this.couponList;
    }

    public void setCouponList(List<RefundCouponInfo> couponList) {
        this.couponList = couponList;
    }

    public Integer getSettlementRefundFee() {
        return this.settlementRefundFee;
    }

    @JSONField(serialize=false)
    public double getFormatSettlementRefundFee() {
        return this.settlementRefundFee != null ? (double)this.settlementRefundFee.intValue() / 100.0 : 0.0;
    }

    public Integer getCouponRefundFee() {
        return this.couponRefundFee;
    }

    @JSONField(serialize=false)
    public double getFormatCouponRefundFee() {
        return this.couponRefundFee != null ? (double)this.couponRefundFee.intValue() / 100.0 : 0.0;
    }

    public Integer getCouponRefundCount() {
        return this.couponRefundCount;
    }

    public String getCouponType() {
        return this.couponType;
    }

    @JSONField(serialize=false)
    public CouponType getFormatCouponType() {
        return this.couponType != null ? CouponType.valueOf(this.couponType.toUpperCase()) : null;
    }

    public String getRefundRecvAccout() {
        return this.refundRecvAccout;
    }

    public String getRefundSuccessTime() {
        return this.refundSuccessTime;
    }

    @JSONField(serialize=false)
    public Date getFormatRefundSuccessTime() {
        return this.refundSuccessTime != null ? DateUtil.parse2yyyyMMddHHmmss(this.refundSuccessTime) : null;
    }

    public String toString() {
        return "RefundDetail [outRefundNo=" + this.outRefundNo + ", refundId=" + this.refundId + ", refundChannel=" + this.refundChannel + ", refundFee=" + this.refundFee + ", refundStatus=" + this.refundStatus + ", settlementRefundFee=" + this.settlementRefundFee + ", couponRefundFee=" + this.couponRefundFee + ", couponRefundCount=" + this.couponRefundCount + ", couponType=" + this.couponType + ", refundRecvAccout=" + this.refundRecvAccout + ", couponList=" + this.couponList + "]";
    }
}

