/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.token;

import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;

public class TicketManager {
    private final String thirdId;
    private final String thirdSecret;
    private final CacheStorager<Token> cacheStorager;

    public TicketManager(String thirdId, String thirdSecret, CacheStorager<Token> cacheStorager) {
        this.thirdId = thirdId;
        this.thirdSecret = thirdSecret;
        this.cacheStorager = cacheStorager;
    }

    public Token getTicket() throws WeixinException {
        return this.cacheStorager.lookup(this.getCacheKey());
    }

    public String getAccessTicket() throws WeixinException {
        return this.getTicket().getAccessToken();
    }

    public String getCacheKey() {
        return String.format("%sthird_party_ticket_%s", "weixin4j_", this.thirdId);
    }

    public void cachingTicket(String ticket) throws WeixinException {
        Token token = new Token(ticket);
        this.cacheStorager.caching(this.getCacheKey(), token);
    }

    public String getThirdId() {
        return this.thirdId;
    }

    public String getThirdSecret() {
        return this.thirdSecret;
    }

    public CacheStorager<Token> getCacheStorager() {
        return this.cacheStorager;
    }
}

