/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.cache;

import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.SerializationUtils;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class RedisClusterCacheStorager<T extends Cacheable>
implements CacheStorager<T> {
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int SO_TIMEOUT = 5000;
    private static final int MAX_REDIRECTIONS = 5;
    private static final int MAX_TOTAL = 50;
    private static final int MAX_IDLE = 5;
    private static final int MAX_WAIT_MILLIS = 5000;
    private static final boolean TEST_ON_BORROW = false;
    private static final boolean TEST_ON_RETURN = true;
    private final JedisCluster jedisCluster;

    public RedisClusterCacheStorager(Set<HostAndPort> nodes) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(50);
        poolConfig.setMaxIdle(5);
        poolConfig.setMaxWaitMillis(5000L);
        poolConfig.setTestOnBorrow(false);
        poolConfig.setTestOnReturn(true);
        this.jedisCluster = new JedisCluster(nodes, 5000, 5000, 5, (GenericObjectPoolConfig)poolConfig);
    }

    public RedisClusterCacheStorager(Set<HostAndPort> nodes, JedisPoolConfig poolConfig) {
        this(nodes, 5000, 5000, 5, poolConfig);
    }

    public RedisClusterCacheStorager(Set<HostAndPort> nodes, int connectionTimeout, int soTimeout, int maxRedirections, JedisPoolConfig poolConfig) {
        this(new JedisCluster(nodes, connectionTimeout, soTimeout, maxRedirections, (GenericObjectPoolConfig)poolConfig));
    }

    public RedisClusterCacheStorager(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    @Override
    public T lookup(String key) {
        byte[] value = this.jedisCluster.get(key.getBytes(Consts.UTF_8));
        return (T)(value != null ? (Cacheable)SerializationUtils.deserialize(value) : null);
    }

    @Override
    public void caching(String key, T cache) {
        byte[] cacheKey = key.getBytes(Consts.UTF_8);
        byte[] value = SerializationUtils.serialize(cache);
        if (cache.getExpires() > 0L) {
            this.jedisCluster.setex(cacheKey, (int)(cache.getExpires() - 60000L) / 1000, value);
        } else {
            this.jedisCluster.set(cacheKey, value);
        }
        this.jedisCluster.sadd("weixin4j_cache_keys", new String[]{key});
    }

    @Override
    public T evict(String key) {
        T cache = this.lookup(key);
        this.jedisCluster.del(key);
        this.jedisCluster.srem("weixin4j_cache_keys", new String[]{key});
        return cache;
    }

    @Override
    public void clear() {
        Set cacheKeys = this.jedisCluster.smembers("weixin4j_cache_keys");
        if (!cacheKeys.isEmpty()) {
            cacheKeys.add("weixin4j_cache_keys");
            this.jedisCluster.del(cacheKeys.toArray(new String[cacheKeys.size()]));
        }
    }
}

