/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.apache.mime;

import com.foxinmy.weixin4j.http.ContentType;
import com.foxinmy.weixin4j.http.apache.content.AbstractContentBody;
import com.foxinmy.weixin4j.http.apache.content.ContentBody;
import com.foxinmy.weixin4j.http.apache.mime.Header;
import com.foxinmy.weixin4j.http.apache.mime.MinimalField;

public class FormBodyPart {
    private final String name;
    private final Header header;
    private final ContentBody body;

    FormBodyPart(String name, ContentBody body, Header header) {
        this.name = name;
        this.body = body;
        this.header = header != null ? header : new Header();
    }

    public FormBodyPart(String name, ContentBody body) {
        this.name = name;
        this.body = body;
        this.header = new Header();
        this.generateContentDisp(body);
        this.generateContentType(body);
        this.generateTransferEncoding(body);
    }

    public String getName() {
        return this.name;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addField(String name, String value) {
        this.header.addField(new MinimalField(name, value));
    }

    protected void generateContentDisp(ContentBody body) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("form-data; name=\"");
        buffer.append(this.getName());
        buffer.append("\"");
        if (body.getFilename() != null) {
            buffer.append("; filename=\"");
            buffer.append(body.getFilename());
            buffer.append("\"");
        }
        this.addField("Content-Disposition", buffer.toString());
    }

    protected void generateContentType(ContentBody body) {
        ContentType contentType = body instanceof AbstractContentBody ? ((AbstractContentBody)body).getContentType() : null;
        if (contentType != null) {
            this.addField("Content-Type", contentType.toString());
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(body.getMimeType());
            if (body.getCharset() != null) {
                buffer.append("; charset=");
                buffer.append(body.getCharset());
            }
            this.addField("Content-Type", buffer.toString());
        }
    }

    protected void generateTransferEncoding(ContentBody body) {
        this.addField("Content-Transfer-Encoding", body.getTransferEncoding());
    }
}

