/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.apache3;

import com.foxinmy.weixin4j.http.AbstractHttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpMethod;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.apache.mime.MultipartEntity;
import com.foxinmy.weixin4j.http.entity.HttpEntity;
import com.foxinmy.weixin4j.http.support.apache3.HttpComponent3Response;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class HttpComponent3
extends AbstractHttpClient {
    private final HttpClient httpClient;

    public HttpComponent3(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws HttpClientException {
        HttpResponse response = null;
        try {
            org.apache.commons.httpclient.HttpMethod httpMethod = this.createRequest(request);
            this.httpClient.executeMethod(httpMethod);
            response = new HttpComponent3Response(httpMethod);
            this.handleResponse(response);
        }
        catch (IOException e) {
            throw new HttpClientException("I/O error on " + request.getMethod().name() + " request for \"" + request.getURI().toString(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return response;
    }

    protected org.apache.commons.httpclient.HttpMethod createRequest(HttpRequest request) throws HttpClientException, IOException {
        org.apache.commons.httpclient.HttpMethod httpMethod = this.createMethod(request);
        this.resolveHeaders(request, httpMethod);
        this.resolveContent(request, httpMethod);
        return httpMethod;
    }

    protected org.apache.commons.httpclient.HttpMethod createMethod(HttpRequest request) throws HttpClientException {
        HttpMethod method = request.getMethod();
        GetMethod httpMethod = null;
        try {
            URI uri = new URI(request.getURI().toString(), false, Consts.UTF_8.name());
            if (method == HttpMethod.GET) {
                httpMethod = new GetMethod();
            } else if (method == HttpMethod.HEAD) {
                httpMethod = new HeadMethod();
            } else if (method == HttpMethod.POST) {
                httpMethod = new PostMethod();
            } else {
                if (method == HttpMethod.PUT) {
                    return new PutMethod();
                }
                if (method == HttpMethod.DELETE) {
                    httpMethod = new DeleteMethod();
                } else if (method == HttpMethod.OPTIONS) {
                    httpMethod = new OptionsMethod();
                } else {
                    if (method == HttpMethod.TRACE) {
                        return new TraceMethod(uri.getEscapedURI());
                    }
                    throw new HttpClientException("unknown request method " + (Object)((Object)method) + " for " + uri);
                }
            }
            httpMethod.setURI(uri);
        }
        catch (IOException e) {
            throw new HttpClientException("I/O error on " + method.name() + " setURI for \"" + request.toString() + "\":" + e.getMessage(), e);
        }
        return httpMethod;
    }

    protected void resolveHeaders(HttpRequest request, org.apache.commons.httpclient.HttpMethod httpMethod) {
        HttpHeaders headers = request.getHeaders();
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (!headers.containsKey("Host")) {
            headers.set("Host", request.getURI().getHost());
        }
        if (!headers.containsKey("Accept")) {
            headers.set("Accept", "*/*");
        }
        if (!headers.containsKey("User-Agent")) {
            headers.set("User-Agent", "apache/httpclient3");
        }
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if ("Cookie".equalsIgnoreCase(header.getKey())) {
                httpMethod.setRequestHeader(header.getKey(), StringUtil.join((Iterable)header.getValue(), ';'));
                continue;
            }
            for (String headerValue : header.getValue()) {
                httpMethod.setRequestHeader(header.getKey(), headerValue != null ? headerValue : "");
            }
        }
    }

    protected void resolveContent(HttpRequest request, org.apache.commons.httpclient.HttpMethod httpMethod) throws IOException {
        HttpEntity entity = request.getEntity();
        if (entity != null) {
            if (entity.getContentLength() > 0L) {
                httpMethod.addRequestHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
            if (entity.getContentType() != null) {
                httpMethod.addRequestHeader("Content-Type", entity.getContentType().toString());
            }
            InputStreamRequestEntity requestEntity = null;
            if (entity instanceof MultipartEntity) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                entity.writeTo(os);
                os.flush();
                requestEntity = new ByteArrayRequestEntity(os.toByteArray(), entity.getContentType().toString());
                os.close();
            } else {
                requestEntity = new InputStreamRequestEntity(entity.getContent(), entity.getContentType().toString());
            }
            ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)requestEntity);
        }
    }

    public static class SSLProtocolSocketFactory
    implements SecureProtocolSocketFactory {
        private final SSLContext sslContext;

        public SSLProtocolSocketFactory(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(host, port, localAddress, localPort);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (params == null) {
                throw new IllegalArgumentException("Parameters may not be null");
            }
            int timeout = params.getConnectionTimeout();
            if (timeout == 0) {
                return this.createSocket(host, port, localAddress, localPort);
            }
            return ControllerThreadSocketFactory.createSocket((ProtocolSocketFactory)this, (String)host, (int)port, (InetAddress)localAddress, (int)localPort, (int)timeout);
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(host, port);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }
    }
}

