/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.apache4;

import com.foxinmy.weixin4j.http.AbstractHttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpMethod;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.apache.mime.MultipartEntity;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;

public abstract class HttpComponent4
extends AbstractHttpClient {
    protected HttpRequestBase createRequest(HttpRequest request) throws HttpClientException, IOException {
        HttpRequestBase httpRequest = this.createMethod(request);
        this.resolveHeaders(request.getHeaders(), httpRequest);
        this.resolveContent(request.getEntity(), httpRequest);
        return httpRequest;
    }

    protected HttpRequestBase createMethod(HttpRequest request) throws HttpClientException {
        HttpMethod method = request.getMethod();
        URI uri = request.getURI();
        if (method == HttpMethod.GET) {
            return new HttpGet(uri);
        }
        if (method == HttpMethod.HEAD) {
            return new HttpHead(uri);
        }
        if (method == HttpMethod.POST) {
            return new HttpPost(uri);
        }
        if (method == HttpMethod.PUT) {
            return new HttpPut(uri);
        }
        if (method == HttpMethod.DELETE) {
            return new HttpDelete(uri);
        }
        if (method == HttpMethod.OPTIONS) {
            return new HttpOptions(uri);
        }
        if (method == HttpMethod.TRACE) {
            return new HttpTrace(uri);
        }
        throw new HttpClientException("unknown request method " + (Object)((Object)method) + " for " + uri);
    }

    protected void resolveHeaders(HttpHeaders headers, HttpRequestBase httpRequest) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        if (!headers.containsKey("Accept")) {
            headers.set("Accept", "*/*");
        }
        if (!headers.containsKey("User-Agent")) {
            headers.set("User-Agent", "apache/httpclient4");
        }
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if ("Cookie".equalsIgnoreCase(header.getKey())) {
                httpRequest.setHeader(header.getKey(), StringUtil.join((Iterable)header.getValue(), ';'));
                continue;
            }
            for (String headerValue : header.getValue()) {
                httpRequest.setHeader(header.getKey(), headerValue != null ? headerValue : "");
            }
        }
    }

    protected void resolveContent(com.foxinmy.weixin4j.http.entity.HttpEntity entity, HttpRequestBase httpRequest) throws IOException {
        if (entity != null) {
            InputStreamEntity httpEntity = null;
            if (entity instanceof MultipartEntity) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                entity.writeTo(os);
                os.flush();
                httpEntity = new ByteArrayEntity(os.toByteArray());
                os.close();
            } else {
                httpEntity = new InputStreamEntity(entity.getContent(), entity.getContentLength());
            }
            httpEntity.setContentType(entity.getContentType().toString());
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)httpEntity);
        }
    }

    protected byte[] getContent(HttpResponse httpResponse) throws IOException {
        return EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
    }

    protected static class CustomHostnameVerifier
    implements X509HostnameVerifier {
        private final HostnameVerifier hostnameVerifier;

        public CustomHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        public boolean verify(String hostname, SSLSession session) {
            return this.hostnameVerifier.verify(hostname, session);
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        }
    }
}

