/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.netty;

import com.foxinmy.weixin4j.http.AbstractHttpResponse;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpStatus;
import com.foxinmy.weixin4j.http.HttpVersion;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;

public class Netty4HttpResponse
extends AbstractHttpResponse {
    private final ChannelHandlerContext context;
    private final FullHttpResponse response;
    private HttpVersion protocol;
    private HttpStatus status;
    private HttpHeaders headers;

    public Netty4HttpResponse(ChannelHandlerContext context, FullHttpResponse response, byte[] content) {
        super(content);
        this.context = context;
        this.response = response;
        this.response.retain();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            for (Map.Entry entry : this.response.headers()) {
                this.headers.add((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this.headers;
    }

    @Override
    public HttpVersion getProtocol() {
        if (this.protocol == null) {
            io.netty.handler.codec.http.HttpVersion version = this.response.getProtocolVersion();
            this.protocol = new HttpVersion(version.protocolName(), version.majorVersion(), version.majorVersion(), version.isKeepAliveDefault());
        }
        return this.protocol;
    }

    @Override
    public HttpStatus getStatus() {
        if (this.status == null) {
            HttpResponseStatus status = this.response.getStatus();
            this.status = new HttpStatus(status.code(), status.reasonPhrase());
        }
        return this.status;
    }

    @Override
    public void close() {
        this.response.release();
        this.context.close();
    }
}

