/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.jssdk;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.jssdk.JSSDKAPI;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.DateUtil;
import com.foxinmy.weixin4j.util.DigestUtil;
import com.foxinmy.weixin4j.util.MapUtil;
import com.foxinmy.weixin4j.util.RandomUtil;
import com.foxinmy.weixin4j.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JSSDKConfigurator {
    private final TokenManager ticketTokenManager;
    private JSONObject config;
    private Set<JSSDKAPI> apis;

    public JSSDKConfigurator(TokenManager ticketTokenManager) {
        this.ticketTokenManager = ticketTokenManager;
        this.config = new JSONObject();
        this.apis = new HashSet<JSSDKAPI>();
    }

    public JSSDKConfigurator debugMode() {
        this.config.put("debug", (Object)true);
        return this;
    }

    public JSSDKConfigurator apis(JSSDKAPI ... apis) {
        for (JSSDKAPI api : apis) {
            this.apis.add(api);
        }
        return this;
    }

    public JSSDKConfigurator apis(JSSDKAPI[] ... apis) {
        for (JSSDKAPI[] api : apis) {
            this.apis(api);
        }
        return this;
    }

    public String toJSONConfig(String url) throws WeixinException {
        if (this.apis.isEmpty()) {
            throw new WeixinException("jsapilist not be empty");
        }
        HashMap<String, String> signMap = new HashMap<String, String>();
        String timestamp = DateUtil.timestamp2string();
        String noncestr = RandomUtil.generateString(24);
        signMap.put("timestamp", timestamp);
        signMap.put("noncestr", noncestr);
        signMap.put("jsapi_ticket", this.ticketTokenManager.getAccessToken());
        signMap.put("url", url);
        String sign = DigestUtil.SHA1(MapUtil.toJoinString(signMap, false, false));
        this.config.put("appId", (Object)this.ticketTokenManager.getWeixinId());
        if (StringUtil.isBlank(this.config.getString("debug"))) {
            this.config.put("debug", (Object)false);
        }
        this.config.put("timestamp", (Object)timestamp);
        this.config.put("nonceStr", (Object)noncestr);
        this.config.put("signature", (Object)sign);
        this.config.put("jsApiList", (Object)this.apis.toArray());
        return this.config.toJSONString();
    }
}

