/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.card;

import com.foxinmy.weixin4j.model.card.CardCoupon;
import com.foxinmy.weixin4j.model.card.CashCoupon;
import com.foxinmy.weixin4j.model.card.CouponAdvanceInfo;
import com.foxinmy.weixin4j.model.card.CouponBaseInfo;
import com.foxinmy.weixin4j.model.card.DiscountCoupon;
import com.foxinmy.weixin4j.model.card.GeneralCoupon;
import com.foxinmy.weixin4j.model.card.GiftCoupon;
import com.foxinmy.weixin4j.model.card.GrouponCoupon;
import com.foxinmy.weixin4j.model.card.MemberCard;

public final class CardCoupons {
    private CardCoupons() {
    }

    public static CouponBaseInfo.Builder customBase() {
        return new CouponBaseInfo.Builder();
    }

    public static CouponAdvanceInfo.Builder customAdvance() {
        return new CouponAdvanceInfo.Builder();
    }

    public static MemberCard.Builder customMemberCard() {
        return new MemberCard.Builder();
    }

    public static CardCoupon createCashCoupon(CouponBaseInfo.Builder builder, double reduceCost, double leastCost) {
        CouponBaseInfo couponBaseInfo = builder.build();
        CashCoupon coupon = new CashCoupon(couponBaseInfo, reduceCost);
        coupon.setLeastCost(leastCost);
        return coupon;
    }

    public static CardCoupon createDiscountCoupon(CouponBaseInfo.Builder builder, int discount) {
        CouponBaseInfo couponBaseInfo = builder.build();
        DiscountCoupon coupon = new DiscountCoupon(couponBaseInfo, discount);
        return coupon;
    }

    public static CardCoupon createGeneralCoupon(CouponBaseInfo.Builder builder, String explain) {
        CouponBaseInfo couponBaseInfo = builder.build();
        GeneralCoupon coupon = new GeneralCoupon(couponBaseInfo, explain);
        return coupon;
    }

    public static CardCoupon createGiftCoupon(CouponBaseInfo.Builder builder, String explain) {
        CouponBaseInfo couponBaseInfo = builder.build();
        GiftCoupon coupon = new GiftCoupon(couponBaseInfo, explain);
        return coupon;
    }

    public static CardCoupon createGrouponCoupon(CouponBaseInfo.Builder builder, String explain) {
        CouponBaseInfo couponBaseInfo = builder.build();
        GrouponCoupon coupon = new GrouponCoupon(couponBaseInfo, explain);
        return coupon;
    }

    public static MemberCard createMemberCard(CouponBaseInfo.Builder baseBuilder, MemberCard.Builder memberCardBudiler) {
        baseBuilder.build();
        MemberCard memberCard = new MemberCard(baseBuilder.build(), memberCardBudiler);
        return memberCard;
    }
}

