/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.coupon.OrderCouponInfo;
import com.foxinmy.weixin4j.payment.mch.MerchantTradeResult;
import com.foxinmy.weixin4j.type.BankType;
import com.foxinmy.weixin4j.type.CurrencyType;
import com.foxinmy.weixin4j.type.TradeState;
import com.foxinmy.weixin4j.type.TradeType;
import com.foxinmy.weixin4j.util.DateUtil;
import com.foxinmy.weixin4j.xml.ListsuffixResult;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Order
extends MerchantTradeResult {
    private static final long serialVersionUID = 5636828325595317079L;
    @XmlElement(name="trade_state")
    @JSONField(name="trade_state")
    private String tradeState;
    @XmlElement(name="openid")
    @JSONField(name="openid")
    private String openId;
    @XmlElement(name="is_subscribe")
    @JSONField(name="is_subscribe")
    private String isSubscribe;
    @XmlElement(name="trade_type")
    @JSONField(name="trade_type")
    private String tradeType;
    @XmlElement(name="bank_type")
    @JSONField(name="bank_type")
    private String bankType;
    @XmlElement(name="cash_fee_type")
    @JSONField(name="cash_fee_type")
    private String cashFeeType;
    @XmlElement(name="coupon_fee")
    @JSONField(name="coupon_fee")
    private Integer couponFee;
    @XmlElement(name="coupon_count")
    @JSONField(name="coupon_count")
    private Integer couponCount;
    @ListsuffixResult
    private List<OrderCouponInfo> couponList;
    private String attach;
    @XmlElement(name="time_end")
    @JSONField(name="time_end")
    private String timeEnd;
    @XmlElement(name="trade_state_desc")
    @JSONField(name="trade_state_desc")
    private String tradeStateDesc;
    @XmlElement(name="sub_openid")
    @JSONField(name="sub_openid")
    private String subOpenId;
    @XmlElement(name="sub_is_subscribe")
    @JSONField(name="sub_is_subscribe")
    private String subIsSubscribe;

    protected Order() {
    }

    @JSONField(serialize=false)
    public TradeState getFormatTradeState() {
        return this.tradeState != null ? TradeState.valueOf(this.tradeState.toUpperCase()) : null;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getIsSubscribe() {
        return this.isSubscribe;
    }

    @JSONField(serialize=false)
    public boolean getFormatIsSubscribe() {
        return this.isSubscribe != null && this.isSubscribe.equalsIgnoreCase("y");
    }

    @JSONField(serialize=false)
    public TradeType getFormatTradeType() {
        return this.tradeType != null ? TradeType.valueOf(this.tradeType.toUpperCase()) : null;
    }

    public String getBankType() {
        return this.bankType;
    }

    @JSONField(serialize=false)
    public BankType getFormatBankType() {
        return this.bankType != null ? BankType.valueOf(this.bankType.toUpperCase()) : null;
    }

    public Integer getCouponFee() {
        return this.couponFee;
    }

    @JSONField(serialize=false)
    public double getFormatCouponFee() {
        return this.couponFee != null ? (double)this.couponFee.intValue() / 100.0 : 0.0;
    }

    public Integer getCouponCount() {
        return this.couponCount;
    }

    public String getTradeState() {
        return this.tradeState;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public String getAttach() {
        return this.attach;
    }

    public String getTimeEnd() {
        return this.timeEnd;
    }

    @JSONField(serialize=false)
    public Date getFormatTimeEnd() {
        return this.timeEnd != null ? DateUtil.parse2yyyyMMddHHmmss(this.timeEnd) : null;
    }

    public String getTradeStateDesc() {
        return this.tradeStateDesc;
    }

    public List<OrderCouponInfo> getCouponList() {
        return this.couponList;
    }

    public void setCouponList(List<OrderCouponInfo> couponList) {
        this.couponList = couponList;
    }

    public String getSubOpenId() {
        return this.subOpenId;
    }

    public String getSubIsSubscribe() {
        return this.subIsSubscribe;
    }

    @JSONField(serialize=false)
    public boolean getFormatSubIsSubscribe() {
        return this.subIsSubscribe != null && this.subIsSubscribe.equalsIgnoreCase("y");
    }

    public String getCashFeeType() {
        return this.cashFeeType;
    }

    @JSONField(serialize=false)
    public CurrencyType getFormatCashFeeType() {
        return this.cashFeeType != null ? CurrencyType.valueOf(this.cashFeeType.toUpperCase()) : null;
    }

    @Override
    public String toString() {
        return "Order [tradeState=" + this.tradeState + ", openId=" + this.openId + ", isSubscribe=" + this.isSubscribe + ", tradeType=" + this.tradeType + ", bankType=" + this.bankType + ", cashFeeType=" + this.cashFeeType + ", couponFee=" + this.couponFee + ", couponCount=" + this.couponCount + ", couponList=" + this.couponList + ", attach=" + this.attach + ", timeEnd=" + this.timeEnd + ", tradeStateDesc=" + this.tradeStateDesc + ", subOpenId=" + this.subOpenId + ", subIsSubscribe=" + this.subIsSubscribe + ", " + super.toString() + "]";
    }
}

