/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.payment.mch.MerchantTradeResult;
import com.foxinmy.weixin4j.payment.mch.RefundDetail;
import com.foxinmy.weixin4j.type.mch.RefundChannel;
import com.foxinmy.weixin4j.xml.ListsuffixResult;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RefundResult
extends MerchantTradeResult {
    private static final long serialVersionUID = -3687863914168618620L;
    @XmlElement(name="out_refund_no")
    @JSONField(name="out_refund_no")
    private String outRefundNo;
    @XmlElement(name="refund_id")
    @JSONField(name="refund_id")
    private String refundId;
    @XmlElement(name="refund_channel")
    @JSONField(name="refund_channel")
    private String refundChannel;
    @XmlElement(name="refund_fee")
    @JSONField(name="refund_fee")
    private int refundFee;
    @XmlElement(name="cash_refund_fee")
    @JSONField(name="cash_refund_fee")
    private Integer cashRefundFee;
    @ListsuffixResult(value={".*(_\\d)$"})
    private List<RefundDetail> refundList;

    protected RefundResult() {
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public String getRefundChannel() {
        return this.refundChannel;
    }

    @JSONField(serialize=false)
    public RefundChannel getFormatRefundChannel() {
        return this.refundChannel != null ? RefundChannel.valueOf(this.refundChannel.toUpperCase()) : null;
    }

    public int getRefundFee() {
        return this.refundFee;
    }

    @JSONField(serialize=false)
    public double getFormatRefundFee() {
        return (double)this.refundFee / 100.0;
    }

    public Integer getCashRefundFee() {
        return this.cashRefundFee;
    }

    @JSONField(serialize=false)
    public double getFormatCashRefundFee() {
        return this.cashRefundFee != null ? (double)this.cashRefundFee.intValue() / 100.0 : 0.0;
    }

    public List<RefundDetail> getRefundList() {
        return this.refundList;
    }

    @Override
    public String toString() {
        return "RefundResult [" + super.toString() + ", outRefundNo=" + this.outRefundNo + ", refundId=" + this.refundId + ", refundChannel=" + this.refundChannel + ", refundFee=" + this.refundFee + ", cashRefundFee=" + this.cashRefundFee + ", refundList=" + this.refundList + "]";
    }
}

