/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.util;

import com.foxinmy.weixin4j.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public class ReflectionUtil {
    public static String getPackageName(Object obj) {
        return obj.getClass().getPackage().getName();
    }

    public static Class<?> getFieldGenericType(Object obj, String fieldName) {
        Field field = ReflectionUtil.getAccessibleField(obj, fieldName);
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    public static Object invokeMethod(Object object, String propertyName) {
        try {
            Method getterMethod = object.getClass().getMethod(propertyName, new Class[0]);
            return getterMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object invokeMethod(Object object, String propertyName, Object ... args) {
        try {
            Method getterMethod = object.getClass().getMethod(propertyName, new Class[0]);
            return getterMethod.invoke(object, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object invokeGetterMethod(Object object, String propertyName) throws Exception {
        String getterMethodName = null;
        Method getterMethod = null;
        String propertyNa = null;
        if (propertyName.contains(".")) {
            propertyNa = StringUtil.substringBefore(propertyName, ".");
            getterMethodName = "get" + StringUtil.capitalize(propertyNa);
            getterMethod = object.getClass().getMethod(getterMethodName, new Class[0]);
            return ReflectionUtil.invokeGetterMethod(getterMethod.invoke(object, new Object[0]), StringUtil.substringAfter(propertyName, "."));
        }
        getterMethodName = "get" + StringUtil.capitalize(propertyName);
        getterMethod = object.getClass().getMethod(getterMethodName, new Class[0]);
        return getterMethod.invoke(object, new Object[0]);
    }

    public static void invokeSetterMethod(Object object, String propertyName, Object propertyValue) {
        Class<?> setterMethodClass = propertyValue.getClass();
        ReflectionUtil.invokeSetterMethod(object, propertyName, propertyValue, setterMethodClass);
    }

    public static void invokeSetterMethod(Object object, String propertyName, Object propertyValue, Class<?> setterMethodClass) {
        String setterMethodName = "set" + StringUtil.capitalize(propertyName);
        try {
            Method setterMethod = object.getClass().getMethod(setterMethodName, setterMethodClass);
            setterMethod.invoke(object, propertyValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        Field field = ReflectionUtil.getAccessibleField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field " + fieldName);
        }
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return result;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtil.getAccessibleField(object, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field " + fieldName);
        }
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    public static String getFieldType(Object object, String fieldName) {
        Field field = ReflectionUtil.getAccessibleField(object, fieldName);
        return field.getType().getSimpleName();
    }

    public static Field getAccessibleField(Object object, String fieldName) {
        Class<?> superClass = object.getClass();
        if (superClass != Object.class) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                return null;
            }
        }
        return null;
    }

    public static Set<Field> getAllField(Class<?> clazz) {
        HashSet<Field> fieldSet = new HashSet<Field>();
        while (clazz != Object.class) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                int modifier = field.getModifiers();
                if (Modifier.isFinal(modifier) || Modifier.isStatic(modifier)) continue;
                fieldSet.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fieldSet;
    }
}

