/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.repository.AGRepositoryConnection;
import junit.framework.Test;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.test.AbstractTestGraph;
import org.junit.AfterClass;
import org.junit.Before;
import test.JenaUtil;

public class AGNamedGraphTest
extends AbstractTestGraph {
    protected static JenaUtil util = new JenaUtil(AGNamedGraphTest.class);
    private static int graphId = 0;
    protected AGRepositoryConnection conn = null;
    protected AGGraphMaker maker = null;

    public AGNamedGraphTest(String name) {
        super(name);
    }

    public static Test suite() {
        return util;
    }

    @AfterClass
    public static void tearDownOnce() {
        util.disconnect();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conn = util.getConn();
        this.maker = util.getMaker();
    }

    public Graph getGraph() {
        AGGraph graph = this.maker.createGraph("http://named" + graphId);
        ++graphId;
        return graph;
    }

    public void testRemoveAll() {
        this.testRemoveAll("");
        this.testRemoveAll("a R b");
        this.testRemoveAll("c S d; e:ff GGG hhhh; i J 27; Ell Em 'en'");
    }

    public void testRemoveAll(String triples) {
        Graph g = this.getGraph();
        AGNamedGraphTest.graphAdd((Graph)g, (String)triples);
        g.clear();
        AGNamedGraphTest.assertTrue((boolean)g.isEmpty());
    }

    public void testIsomorphismFile() {
    }

    public void testBulkUpdate() {
        super.testBulkUpdate();
    }

    public void testContainsByValue() {
        super.testContainsByValue();
    }

    public void testContainsConcrete() {
        Graph g = this.getGraphWith("s P o; x R y; x S 0");
        AGNamedGraphTest.assertTrue((boolean)g.contains(AGNamedGraphTest.triple((String)"s P o")));
        AGNamedGraphTest.assertTrue((boolean)g.contains(AGNamedGraphTest.triple((String)"x R y")));
        AGNamedGraphTest.assertTrue((boolean)g.contains(AGNamedGraphTest.triple((String)"x S 0")));
        AGNamedGraphTest.assertFalse((boolean)g.contains(AGNamedGraphTest.triple((String)"s P Oh")));
        AGNamedGraphTest.assertFalse((boolean)g.contains(AGNamedGraphTest.triple((String)"S P O")));
        AGNamedGraphTest.assertFalse((boolean)g.contains(AGNamedGraphTest.triple((String)"s p o")));
        AGNamedGraphTest.assertFalse((boolean)g.contains(AGNamedGraphTest.triple((String)"x r y")));
        AGNamedGraphTest.assertFalse((boolean)g.contains(AGNamedGraphTest.triple((String)"x S 1")));
    }

    public void testContainsNode() {
        Graph g = this.getGraph();
        AGNamedGraphTest.graphAdd((Graph)g, (String)"a P b; c Q d; a R 12");
        AGNamedGraphTest.assertTrue((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"a")));
        AGNamedGraphTest.assertTrue((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"P")));
        AGNamedGraphTest.assertTrue((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"b")));
        AGNamedGraphTest.assertTrue((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"c")));
        AGNamedGraphTest.assertTrue((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"Q")));
        AGNamedGraphTest.assertTrue((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"d")));
        AGNamedGraphTest.assertTrue((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"R")));
        AGNamedGraphTest.assertTrue((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"12")));
        AGNamedGraphTest.assertFalse((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"x")));
        AGNamedGraphTest.assertFalse((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"_y")));
        AGNamedGraphTest.assertFalse((boolean)this.containsNode(g, AGNamedGraphTest.node((String)"99")));
    }

    private boolean containsNode(Graph g, Node node) {
        return GraphUtil.containsNode((Graph)g, (Node)node);
    }
}

