/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.repository.AGServer;
import junit.framework.Assert;
import org.junit.Test;
import test.AGAbstractTest;

public class AGServerTests
extends AGAbstractTest {
    void verifyUserAndPassword(AGServer server, boolean anonymous) {
        String gotUser = server.getUser();
        String gotPassword = server.getPassword();
        String expectedUser = anonymous ? null : AGServerTests.username();
        String expectedPassword = anonymous ? null : AGServerTests.password();
        Assert.assertEquals((String)String.format("Expected user '%s' but got '%s'", expectedUser, gotUser), (String)expectedUser, (String)gotUser);
        Assert.assertEquals((String)String.format("Expected password '%s' but got '%s'", expectedPassword, gotPassword), (String)expectedPassword, (String)gotPassword);
    }

    @Test
    public void AGServerConstructorTest1() {
        try (AGServer server = new AGServer(AGServerTests.findServerUrl(), AGServerTests.username(), AGServerTests.password());){
            this.verifyUserAndPassword(server, false);
        }
    }

    @Test
    public void AGServerConstructorTest2() {
        AGHTTPClient cli = new AGHTTPClient(AGServerTests.findServerUrl());
        try (AGServer server = new AGServer(AGServerTests.username(), AGServerTests.password(), cli);){
            this.verifyUserAndPassword(server, false);
        }
    }

    @Test
    public void AGServerConstructorTest3() {
        AGHTTPClient cli = new AGHTTPClient(AGServerTests.findServerUrl());
        cli.setUsernameAndPassword(AGServerTests.username(), AGServerTests.password());
        try (AGServer server = new AGServer(cli);){
            this.verifyUserAndPassword(server, false);
        }
    }

    @Test
    public void AGServerConstructorTest4() {
        try (AGServer server = new AGServer(AGServerTests.findServerUrl());){
            this.verifyUserAndPassword(server, true);
        }
    }
}

