/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGServerVersion;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class AGServerVersionTests {
    @Test(expected=NullPointerException.class)
    public void testCompareWithNull() {
        new AGServerVersion("v6.4.1").compareTo(null);
    }

    @Test
    public void testEqualsWithNull() {
        Assert.assertNotEquals((Object)new AGServerVersion("v6.4.1"), null);
    }

    @Test
    public void testEqualsWithWrongClass() {
        Assert.assertNotEquals((Object)new AGServerVersion("v6.4.1"), (Object)"v6.4.1");
    }

    @Test
    public void testToString() {
        Assert.assertTrue((boolean)new AGServerVersion("1-blorp0").toString().contains("blorp"));
    }

    public static class EqualsTests {
        private final AGServerVersion a;
        private final AGServerVersion b;
        private final boolean expected;

        public static Collection<Object[]> data() {
            return Arrays.asList({"1", "1", true}, {"1.0", "1.0", true}, {"1.0", "1-0", true}, {"ab1cd2ef3gh", "x1y2z3", false}, {"2", "1", false}, {"2.0", "1.1", false}, {"2.0.1", "2.0", false}, {"2.0.0", "2.0", true});
        }

        public EqualsTests(String a, String b, boolean expected) {
            this.a = new AGServerVersion(a);
            this.b = new AGServerVersion(b);
            this.expected = expected;
        }

        @Test
        public void test() {
            boolean actual = this.a.equals((Object)this.b);
            Assert.assertEquals((Object)this.expected, (Object)actual);
        }

        @Test
        public void testReversed() {
            boolean actual = this.b.equals((Object)this.a);
            Assert.assertEquals((Object)this.expected, (Object)actual);
        }

        @Test
        public void testHashCode() {
            if (this.expected) {
                Assert.assertEquals((long)this.a.hashCode(), (long)this.b.hashCode());
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class CompareTests {
        private final AGServerVersion a;
        private final AGServerVersion b;
        private final Integer expected;

        public static Collection<Object[]> data() {
            return Arrays.asList({"1", "1", 0}, {"1.0", "1.0", 0}, {"1.0", "1-0", 0}, {"ab1cd2ef3gh", "x1y2z3", 0}, {"2", "1", 1}, {"2.0", "1.1", 1}, {"2.0.1", "2.0", 1}, {"2.0.0", "2.0", 0});
        }

        public CompareTests(String a, String b, Integer expected) {
            this.a = new AGServerVersion(a);
            this.b = new AGServerVersion(b);
            this.expected = expected;
        }

        @Test
        public void test() {
            try {
                Integer actual = Integer.signum(this.a.compareTo(this.b));
                Assert.assertEquals((Object)this.expected, (Object)actual);
            }
            catch (NullPointerException e) {
                Assert.assertNull((String)"Expected exception not thrown", (Object)this.expected);
            }
        }

        @Test
        public void testReversed() {
            try {
                Integer actual = Integer.signum(-this.b.compareTo(this.a));
                Assert.assertEquals((Object)this.expected, (Object)actual);
            }
            catch (NullPointerException e) {
                Assert.assertNull((String)"Expected exception not thrown", (Object)this.expected);
            }
        }
    }
}

