/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGModel;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;

public class BlankNodeTests
extends AGAbstractTest {
    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaExternalBlankNodeRoundTrips_spr38494() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.createGraph("http://aldi1.com.au"));
        AGModel model1 = this.closeLater(new AGModel(graph));
        org.apache.jena.rdf.model.Resource bnode = ResourceFactory.createResource();
        org.apache.jena.rdf.model.Resource bnode2 = model1.createResource(AnonId.create((String)"ex"));
        model1.begin();
        model1.removeAll();
        model1.add(bnode, RDF.type, (RDFNode)bnode2);
        model1.commit();
        Assert.assertEquals((long)1L, (long)model1.size());
        Assert.assertTrue((boolean)model1.contains(bnode, RDF.type, (RDFNode)bnode2));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void jenaModelBlankNodeRoundTrips_spr38494() throws Exception {
        AGGraphMaker maker = this.closeLater(new AGGraphMaker(this.conn));
        AGGraph graph = this.closeLater(maker.createGraph("http://aldi1.com.au"));
        AGModel model1 = this.closeLater(new AGModel(graph));
        org.apache.jena.rdf.model.Resource bnode = model1.createResource();
        model1.begin();
        model1.removeAll();
        model1.add(bnode, RDF.type, (RDFNode)OWL.Thing);
        model1.commit();
        Assert.assertEquals((long)1L, (long)model1.size());
        Assert.assertTrue((boolean)model1.contains(bnode, RDF.type, (RDFNode)OWL.Thing));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sesameExternalBlankNodeRoundTrips_spr38494() throws Exception {
        BNode bnode = ValueFactoryImpl.getInstance().createBNode();
        BNode bnode2 = this.vf.createBNode("external");
        IRI p = this.vf.createIRI("http://p");
        this.conn.clear(new Resource[0]);
        try {
            this.conn.add((Resource)bnode, p, (Value)bnode2, new Resource[]{p});
            Assert.fail((String)"Expected an exception: can't add external blank nodes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.conn.prepareHttpRepoClient().setAllowExternalBlankNodeIds(true);
        this.conn.add((Resource)bnode, p, (Value)bnode, new Resource[]{p});
        Assert.assertEquals((long)1L, (long)this.conn.size(new Resource[0]));
        Assert.assertTrue((boolean)this.conn.hasStatement((Resource)bnode, p, (Value)bnode, false, new Resource[]{p}));
        RepositoryResult results = this.conn.getStatements((Resource)bnode, p, (Value)bnode, false, new Resource[]{p});
        this.closeLater(results);
        Assert.assertTrue((boolean)results.hasNext());
        Statement st = (Statement)results.next();
        Assert.assertEquals((Object)bnode, (Object)st.getSubject());
        Assert.assertEquals((Object)bnode, (Object)st.getObject());
        GraphQueryResult results2 = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, "construct {?s <http://foo> ?o} where {?s ?p ?o}").evaluate();
        this.closeLater(results2);
        Assert.assertTrue((boolean)results2.hasNext());
        st = (Statement)results2.next();
        Assert.assertEquals((Object)bnode, (Object)st.getSubject());
        Assert.assertEquals((Object)bnode, (Object)st.getObject());
        TupleQueryResult results3 = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "select * where {?s ?p ?o}").evaluate();
        this.closeLater(results3);
        Assert.assertTrue((boolean)results3.hasNext());
        BindingSet result = (BindingSet)results3.next();
        Assert.assertEquals((Object)bnode, (Object)result.getValue("s"));
        Assert.assertEquals((Object)bnode, (Object)result.getValue("o"));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void sesameAGBlankNodeRoundTrips_spr38494() throws Exception {
        BNode bnode = this.vf.createBNode();
        IRI p = this.vf.createIRI("http://p");
        this.conn.clear(new Resource[0]);
        this.conn.add((Resource)bnode, p, (Value)bnode, new Resource[]{p});
        Assert.assertEquals((long)1L, (long)this.conn.size(new Resource[0]));
        Assert.assertTrue((boolean)this.conn.hasStatement((Resource)bnode, p, (Value)bnode, false, new Resource[]{p}));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void blankNodesPerRequest() throws Exception {
        this.vf.setBlankNodesPerRequest(this.vf.getBlankNodesPerRequest() * 10);
        this.vf.createBNode();
        Assert.assertEquals((long)this.vf.getBlankNodesPerRequest(), (long)this.vf.getBlankNodeIds().length);
    }
}

